/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.testing.behavior;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class TempJavaFileManager
implements JavaFileManager {
    private final StandardJavaFileManager delegate = ToolProvider.getSystemJavaCompiler().getStandardFileManager(null, null, null);

    public TempJavaFileManager() {
        try {
            this.delegate.setLocation(StandardLocation.SOURCE_OUTPUT, (Iterable<? extends File>)ImmutableList.of((Object)Files.createTempDir()));
            this.delegate.setLocation(StandardLocation.CLASS_OUTPUT, (Iterable<? extends File>)ImmutableList.of((Object)Files.createTempDir()));
        }
        catch (IOException e) {
            throw new IllegalStateException("Directory rejected by standard file manager", e);
        }
    }

    @Override
    public int isSupportedOption(String option) {
        return this.delegate.isSupportedOption(option);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.delegate.getClassLoader(location);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return this.delegate.isSameFile(a, b);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        return this.delegate.list(location, packageName, kinds, recurse);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        return this.delegate.inferBinaryName(location, file);
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        return this.delegate.handleOption(current, remaining);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.delegate.hasLocation(location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        return this.delegate.getJavaFileForInput(location, className, kind);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        return this.delegate.getJavaFileForOutput(location, className, kind, sibling);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        return this.delegate.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        return this.delegate.getFileForOutput(location, packageName, relativeName, sibling);
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() {
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            TempJavaFileManager.recursiveDelete((File)Iterables.getOnlyElement(this.delegate.getLocation(StandardLocation.SOURCE_OUTPUT)));
            TempJavaFileManager.recursiveDelete((File)Iterables.getOnlyElement(this.delegate.getLocation(StandardLocation.CLASS_OUTPUT)));
        }
    }

    private static void recursiveDelete(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File each : files) {
                TempJavaFileManager.recursiveDelete(each);
            }
        }
        file.delete();
    }
}

