/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.testing.behavior;

import com.google.common.base.Strings;
import com.google.common.collect.MapMaker;
import com.google.common.truth.Truth;
import java.util.concurrent.ConcurrentMap;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.inferred.testing.behavior.SourceBuilder;
import org.junit.Assert;
import org.junit.Test;

public class TestBuilder {
    private final StringBuilder imports = new StringBuilder();
    private final StringBuilder code = new StringBuilder();
    private int lineNumber = 2;

    public TestBuilder addStaticImport(Class<?> cls, String method) {
        return this.addStaticImport(cls.getCanonicalName(), method);
    }

    public TestBuilder addStaticImport(String cls, String method) {
        this.imports.append("import static ").append(cls).append(".").append(method).append("; ");
        return this;
    }

    public TestBuilder addImport(Class<?> cls) {
        return this.addImport(cls.getCanonicalName());
    }

    public TestBuilder addImport(String cls) {
        this.imports.append("import ").append(cls).append("; ");
        return this;
    }

    public TestBuilder addLine(String fmt, Object ... args) {
        StackTraceElement caller = new Exception().getStackTrace()[1];
        if (caller.getLineNumber() > this.lineNumber) {
            this.code.append(Strings.repeat((String)"\n", (int)(caller.getLineNumber() - this.lineNumber)));
            this.lineNumber = caller.getLineNumber();
        }
        Object[] substituteArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            substituteArgs[i] = SourceBuilder.substitute(args[i]);
        }
        String text = String.format(fmt, substituteArgs);
        this.lineNumber += text.length() - text.replace("\n", "").length() + 1;
        this.code.append(text).append("\n");
        return this;
    }

    public JavaFileObject build() {
        StackTraceElement caller = new Exception().getStackTrace()[1];
        return new TestSource(TestBuilder.uniqueTestClassName(caller.getClassName()), caller.getMethodName(), this.imports.toString(), this.code.toString());
    }

    private static UniqueName uniqueTestClassName(String originalClassName) {
        int periodIndex = originalClassName.lastIndexOf(46);
        String suggestion = periodIndex != -1 ? originalClassName.substring(0, periodIndex) + ".generatedcode" + originalClassName.substring(periodIndex) : "com.example.test.generatedcode.Test";
        UniqueName className = new UniqueName(suggestion);
        return className;
    }

    private static class TestSource
    extends SimpleJavaFileObject {
        private final UniqueName className;
        private final String source;

        private TestSource(UniqueName className, String methodName, String imports, String testCode) {
            super(SourceBuilder.uriForClass(className.getName()), JavaFileObject.Kind.SOURCE);
            this.className = className;
            this.source = "package " + className.getNamespace() + "; " + "import static " + Assert.class.getName() + ".*; " + "import static " + Truth.class.getName() + ".assertThat; " + imports + "public class " + className.getSimpleName() + " {" + "  @" + Test.class.getName() + "  public static void " + methodName + "() throws Exception {\n" + testCode + "\n  }\n}";
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.source;
        }
    }

    private static class UniqueName {
        private static final ConcurrentMap<String, UniqueName> USED_NAMES = new MapMaker().weakValues().makeMap();
        private final String name;

        UniqueName(String suggestion) {
            System.gc();
            String attempt = suggestion;
            int attemptNumber = 1;
            while (USED_NAMES.putIfAbsent(attempt, this) != null) {
                attempt = suggestion + "__" + ++attemptNumber;
            }
            this.name = attempt;
        }

        String getName() {
            return this.name;
        }

        String getSimpleName() {
            return this.name.substring(this.name.lastIndexOf(46) + 1);
        }

        String getNamespace() {
            return this.name.substring(0, this.name.lastIndexOf(46));
        }
    }
}

