/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.testing.behavior;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Processor;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.inferred.testing.behavior.CompilationException;
import org.inferred.testing.behavior.SourceBuilder;
import org.inferred.testing.behavior.TempJavaFileManager;
import org.junit.Assert;
import org.junit.Test;

public class BehaviorTester {
    private final List<Processor> processors = new ArrayList<Processor>();
    private final List<JavaFileObject> compilationUnits = new ArrayList<JavaFileObject>();
    private boolean shouldSetContextClassLoader = false;

    public BehaviorTester with(Processor processor) {
        this.processors.add(processor);
        return this;
    }

    public BehaviorTester with(JavaFileObject compilationUnit) {
        this.compilationUnits.add(compilationUnit);
        return this;
    }

    public BehaviorTester withContextClassLoader() {
        this.shouldSetContextClassLoader = true;
        return this;
    }

    public void runTest() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TempJavaFileManager fileManager = new TempJavaFileManager();){
            BehaviorTester.compile(fileManager, this.compilationUnits, this.processors);
            final ClassLoader classLoader = fileManager.getClassLoader(StandardLocation.CLASS_OUTPUT);
            final ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
            if (this.shouldSetContextClassLoader) {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        BehaviorTester.this.runTests(classLoader, exceptions);
                    }
                };
                t.setContextClassLoader(classLoader);
                t.start();
                Uninterruptibles.joinUninterruptibly((Thread)t);
            } else {
                this.runTests(classLoader, exceptions);
                if (exceptions.size() == 1) {
                    Throwables.propagateIfPossible((Throwable)((Throwable)exceptions.get(0)));
                }
            }
            if (!exceptions.isEmpty()) {
                Throwable cause = (Throwable)exceptions.remove(0);
                RuntimeException aggregate = new RuntimeException("Behavioral test failed", cause);
                for (Throwable suppressed : exceptions) {
                    aggregate.addSuppressed(suppressed);
                }
                throw aggregate;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void runTests(ClassLoader classLoader, List<Throwable> throwables) {
        for (Class<?> compiledClass : BehaviorTester.loadCompiledClasses(classLoader, this.compilationUnits)) {
            for (Method testMethod : BehaviorTester.getTestMethods(compiledClass)) {
                try {
                    testMethod.invoke(testMethod.getDeclaringClass().newInstance(), new Object[0]);
                }
                catch (InvocationTargetException e) {
                    throwables.add(e.getCause());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throwables.add((Throwable)((Object)new AssertionError("Unexpected failure", e)));
                }
            }
        }
    }

    private static List<Class<?>> loadCompiledClasses(ClassLoader classLoader, Iterable<? extends JavaFileObject> compilationUnits) {
        try {
            ImmutableList.Builder resultBuilder = ImmutableList.builder();
            for (JavaFileObject javaFileObject : compilationUnits) {
                if (javaFileObject.getKind() != JavaFileObject.Kind.SOURCE) continue;
                String typeName = SourceBuilder.getTypeNameFromSource(javaFileObject.getCharContent(true));
                resultBuilder.add(classLoader.loadClass(typeName));
            }
            return resultBuilder.build();
        }
        catch (IOException | ClassNotFoundException e) {
            Assert.fail((String)("Unexpected failure: " + e));
            return null;
        }
    }

    private static List<Method> getTestMethods(Class<?> cls) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        Method[] methodArray = cls.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(Test.class)) {
                Preconditions.checkState((boolean)Modifier.isPublic(method.getModifiers()), (String)"Test %s#%s is not public", (Object[])new Object[]{cls.getName(), method.getName()});
                Preconditions.checkState((method.getParameterTypes().length == 0 ? 1 : 0) != 0, (String)"Test %s#%s has parameters", (Object[])new Object[]{cls.getName(), method.getName()});
                resultBuilder.add((Object)method);
            }
            ++n2;
        }
        return resultBuilder.build();
    }

    private static void compile(JavaFileManager fileManager, Iterable<? extends JavaFileObject> compilationUnits, Iterable<? extends Processor> processors) {
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        JavaCompiler.CompilationTask task = BehaviorTester.getCompiler().getTask(null, fileManager, diagnostics, null, null, compilationUnits);
        task.setProcessors(processors);
        boolean successful = task.call();
        if (!successful) {
            throw new CompilationException(diagnostics.getDiagnostics());
        }
    }

    private static JavaCompiler getCompiler() {
        return ToolProvider.getSystemJavaCompiler();
    }
}

