/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.doclets.html;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class HtmlGenerator {
    Map<String, String> subs = new HashMap<String, String>();

    public HtmlGenerator(String title, String description, String keywords) {
        this.subs.put("title", title);
        this.subs.put("description", description);
        this.subs.put("keywords", keywords);
    }

    public void generateHtml(String fileName) throws IOException {
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), StandardCharsets.UTF_8));){
            this.copyToWriter(pw, "header.html");
            this.generateContents(pw);
            this.copyToWriter(pw, "footer.html");
        }
    }

    protected abstract void generateContents(PrintWriter var1);

    protected boolean isValid(String s) {
        return s != null && s.trim().length() != 0;
    }

    private void copyToWriter(PrintWriter pw, String resourceName) throws IOException {
        Pattern pattern = Pattern.compile("%%(\\w+)%%");
        try (BufferedReader r = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(resourceName)));){
            String line = r.readLine();
            while (line != null) {
                Matcher matcher = pattern.matcher(line);
                StringBuffer sb = new StringBuffer();
                while (matcher.find()) {
                    matcher.appendReplacement(sb, this.subs.get(matcher.group(1)));
                }
                matcher.appendTail(sb);
                pw.println(sb);
                line = r.readLine();
            }
        }
    }
}

