/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.doclets.jmx;

import java.io.PrintWriter;
import java.util.List;
import org.infinispan.doclets.html.HtmlGenerator;
import org.infinispan.doclets.jmx.MBeanAttribute;
import org.infinispan.doclets.jmx.MBeanComponent;
import org.infinispan.doclets.jmx.MBeanOperation;

public class JmxHtmlGenerator
extends HtmlGenerator {
    private final String title;
    List<MBeanComponent> components;

    public JmxHtmlGenerator(String title, String description, String keywords, List<MBeanComponent> components) {
        super(title, description, keywords);
        this.title = title;
        this.components = components;
    }

    @Override
    protected void generateContents(PrintWriter w) {
        w.println("<div class=\"header\">");
        w.printf("<h1>%s</h1>", this.title);
        w.println("</div>");
        w.println("<div class=\"contentContainer\">");
        w.println("<table class=\"typeSummary\">");
        w.println("<caption><span>MBean Summary</span><span class=\"tabEnd\">&nbsp;</span></caption>");
        w.println("<tr>\n<th class=\"colFirst\" scope=\"col\">Name</th>\n<th class=\"colLast\" scope=\"col\">Description</th>\n</tr>");
        w.println("<tbody>");
        int row = 0;
        for (MBeanComponent mbean : this.components) {
            w.printf("<tr class=\"%s\">", this.rowClass(row++));
            w.printf("<th class=\"colFirst\" scope=\"row\"><a href=\"#%s\">%s</a></th><td>%s</td></tr>", mbean.name, mbean.name, mbean.desc);
        }
        w.println("</tbody></table>");
        w.printf("<div class=\"details\"><ul class=\"blockList\"><li class=\"blockList\">", new Object[0]);
        for (MBeanComponent mbean : this.components) {
            w.printf("<a name=\"%s\" />", mbean.name);
            w.printf("<section role=\"region\"><ul class=\"blockList\"><li class=\"blockList\">", new Object[0]);
            w.printf("<h3><a href=\"%s\">%s</a></h3>", this.toURL(mbean.className), mbean.name);
            w.printf("<p>%s</p>", mbean.desc);
            if (!mbean.attributes.isEmpty()) {
                w.println("<table class=\"typeSummary\">");
                w.printf("<caption><span>Attributes</span><span class=\"tabEnd\">&nbsp;</span></caption>", new Object[0]);
                w.println("<tr><th class=\"colFirst\" scope=\"col\">Name</th><th class=\"colSecond\" scope=\"col\">Description</th><th class=\"colSecond\" scope=\"col\">Type</th><th class=\"colLast\" scope=\"col\">Writable</th></tr>");
                w.println("<tbody>");
                row = 0;
                for (MBeanAttribute attr : mbean.attributes.values()) {
                    w.printf("<tr class=\"%s\">", this.rowClass(row++));
                    w.printf("<td><tt>%s</tt></td>", attr.name);
                    w.printf("<td>%s</td>", attr.desc);
                    w.printf("<td><tt>%s</tt></td>", attr.type);
                    w.printf("<td>%s</td>", attr.writable);
                    w.println("</tr>");
                }
                w.println("</tbody></table>");
            }
            if (!mbean.operations.isEmpty()) {
                w.println("<table class=\"typeSummary\">");
                w.printf("<caption><span>Operations</span><span class=\"tabEnd\">&nbsp;</span></caption>", new Object[0]);
                w.println("<tr><th class=\"colFirst\" scope=\"col\">Name</th><th  class=\"colSecond\" scope=\"col\">Description</th><th class=\"colLast\" scope=\"col\">Signature</th></tr>");
                w.println("<tbody>");
                row = 0;
                for (MBeanOperation operation : mbean.operations.values()) {
                    w.printf("<tr class=\"%s\">", this.rowClass(row++));
                    w.printf("<td><tt>%s</tt></td>", operation.name);
                    w.printf("<td>%s</td>", operation.desc);
                    w.printf("<td><tt>%s</tt></td>", this.generateSignature(operation));
                    w.println("</tr>");
                }
                w.println("</tbody></table>");
            }
            w.println("</li></ul></section>");
        }
        w.println("</li></ul></div>");
        w.println("</div>");
    }

    private String rowClass(int i) {
        return i % 2 == 0 ? "altColor" : "rowColor";
    }

    private String toURL(String fqcn) {
        return fqcn.replace(".", "/") + ".html";
    }

    private String generateSignature(MBeanOperation op) {
        StringBuilder sb = new StringBuilder();
        if (this.isValid(op.returnType)) {
            sb.append(JmxHtmlGenerator.escapeHTML(op.returnType));
        } else {
            sb.append("void");
        }
        sb.append(" ").append(op.name);
        if (this.isValid(op.signature)) {
            sb.append("(").append(JmxHtmlGenerator.escapeHTML(op.signature)).append(")");
        } else {
            sb.append("()");
        }
        return sb.toString();
    }

    public static String escapeHTML(String s) {
        StringBuilder out = new StringBuilder(Math.max(16, s.length()));
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f' || c == '\"' || c == '<' || c == '>' || c == '&') {
                out.append("&#");
                out.append((int)c);
                out.append(';');
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }
}

