/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.doclets;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import jdk.javadoc.doclet.StandardDoclet;
import org.infinispan.doclets.bytebuddy.ByteBuddy;
import org.infinispan.doclets.bytebuddy.implementation.MethodDelegation;
import org.infinispan.doclets.bytebuddy.matcher.ElementMatchers;
import org.infinispan.doclets.jmx.JmxDoclet;

public final class DocletMultiplexer
implements Doclet {
    private static final String PRIVATE_TAG = "@private";
    private static final String PUBLIC_TAG = "@public";
    private final StandardDoclet standardDoclet = new StandardDoclet();
    private final JmxDoclet jmxDoclet = new JmxDoclet();
    private Reporter reporter;

    @Override
    public void init(Locale locale, Reporter reporter) {
        this.reporter = reporter;
        this.standardDoclet.init(locale, reporter);
        this.jmxDoclet.init(locale, reporter);
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Set<? extends Doclet.Option> getSupportedOptions() {
        HashSet<Doclet.Option> options = new HashSet<Doclet.Option>();
        options.addAll(this.standardDoclet.getSupportedOptions());
        options.addAll(this.jmxDoclet.getSupportedOptions());
        return options;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return this.standardDoclet.getSupportedSourceVersion();
    }

    private static boolean isPublicAPI(DocletEnvironment env, Element e) {
        Objects.requireNonNull(env);
        Objects.requireNonNull(e);
        if (DocletMultiplexer.hasTag(env, e, PRIVATE_TAG)) {
            return false;
        }
        if (e instanceof ModuleElement) {
            return true;
        }
        if (DocletMultiplexer.hasTag(env, e, PUBLIC_TAG)) {
            return !DocletMultiplexer.isMarkedPrivate(env, e);
        }
        Element enclosingElement = e.getEnclosingElement();
        if (enclosingElement != null) {
            return DocletMultiplexer.isPublicAPI(env, enclosingElement);
        }
        return false;
    }

    private static boolean isMarkedPrivate(DocletEnvironment env, Element e) {
        if (DocletMultiplexer.hasTag(env, e, PRIVATE_TAG)) {
            return true;
        }
        Element enclosingElement = e.getEnclosingElement();
        return enclosingElement != null && DocletMultiplexer.isMarkedPrivate(env, enclosingElement);
    }

    private static boolean hasTag(DocletEnvironment env, Element e, String tag) {
        String docComment = env.getElementUtils().getDocComment(e);
        if (docComment == null) {
            return false;
        }
        int pos = docComment.indexOf(tag);
        if (pos == -1) {
            return false;
        }
        int after = pos + tag.length();
        return after == docComment.length() || Character.isWhitespace(docComment.charAt(after));
    }

    private static String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    @Override
    public boolean run(DocletEnvironment environment) {
        DocletEnvironment proxyEnv;
        boolean result = this.jmxDoclet.run(environment);
        try {
            this.filterUnmodifiableSet(environment.getSpecifiedElements(), e -> this.filterElement(environment, (Element)e));
            this.filterUnmodifiableSet(environment.getIncludedElements(), e -> this.filterElement(environment, (Element)e));
        }
        catch (Exception ex) {
            this.reporter.print(Diagnostic.Kind.ERROR, "Failed to filter element set");
            this.reporter.print(Diagnostic.Kind.ERROR, DocletMultiplexer.getStackTraceAsString(ex));
        }
        try {
            proxyEnv = this.makeDocletEnvironmentProxy(environment);
        }
        catch (Exception ex) {
            this.reporter.print(Diagnostic.Kind.ERROR, "Failed to proxify DocletEnvironment");
            this.reporter.print(Diagnostic.Kind.ERROR, DocletMultiplexer.getStackTraceAsString(ex));
            proxyEnv = environment;
        }
        return result &= this.standardDoclet.run(proxyEnv);
    }

    private boolean filterElement(DocletEnvironment env, Element e) {
        boolean result = DocletMultiplexer.isPublicAPI(env, e);
        return result;
    }

    private <X> void filterUnmodifiableSet(Set<? extends X> unmodifiableSet, Predicate<X> predicate) throws Exception {
        Class<?> zeeClazz = unmodifiableSet.getClass();
        Field c = zeeClazz.getSuperclass().getDeclaredField("c");
        c.setAccessible(true);
        Set innerSet = (Set)c.get(unmodifiableSet);
        HashSet toRemove = new HashSet();
        for (Object e : innerSet) {
            if (predicate.test(e)) continue;
            toRemove.add(e);
        }
        innerSet.removeAll(toRemove);
    }

    private DocletEnvironment makeDocletEnvironmentProxy(DocletEnvironment environment) throws Exception {
        Class<?> envImplClass = environment.getClass();
        HashMap fieldsByType = new HashMap();
        for (Field f : envImplClass.getDeclaredFields()) {
            f.setAccessible(true);
            Object v = f.get(environment);
            if (v == null) continue;
            fieldsByType.put(f.getType(), v);
        }
        Optional<Constructor> maxCtor = Arrays.stream(envImplClass.getDeclaredConstructors()).max(Comparator.comparingInt(Constructor::getParameterCount));
        Class<?>[] paramTypes = maxCtor.get().getParameterTypes();
        Object[] paramValues = new Object[paramTypes.length];
        for (int i = 0; i < paramValues.length; ++i) {
            paramValues[i] = fieldsByType.get(paramTypes[i]);
        }
        DocletEnvironmentInterceptor interceptor = new DocletEnvironmentInterceptor(environment);
        Class proxyClass = new ByteBuddy().subclass(envImplClass).method(ElementMatchers.named("isIncluded")).intercept(MethodDelegation.to(interceptor)).method(ElementMatchers.named("isSelected")).intercept(MethodDelegation.to(interceptor)).make().load(this.getClass().getClassLoader()).getLoaded();
        Constructor ctor = proxyClass.getConstructor(paramTypes);
        return (DocletEnvironment)ctor.newInstance(paramValues);
    }

    public final class DocletEnvironmentInterceptor {
        private final DocletEnvironment original;

        DocletEnvironmentInterceptor(DocletEnvironment original) {
            this.original = original;
        }

        public boolean isIncluded(Element e) {
            return this.original.isIncluded(e) && DocletMultiplexer.this.filterElement(this.original, e);
        }

        public boolean isSelected(Element e) {
            return this.original.isSelected(e) && DocletMultiplexer.this.filterElement(this.original, e);
        }
    }
}

