/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.doclets;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import jdk.javadoc.doclet.StandardDoclet;
import org.infinispan.doclets.bytebuddy.ByteBuddy;
import org.infinispan.doclets.bytebuddy.implementation.MethodDelegation;
import org.infinispan.doclets.bytebuddy.matcher.ElementMatchers;
import org.infinispan.doclets.jmx.JmxDoclet;
import org.infinispan.doclets.jmx.LambdaOption;

public final class DocletMultiplexer
implements Doclet {
    private static final String EXCLUDE_GENERATED_BY = "--excludeGeneratedBy";
    private static final String PRIVATE_TAG = "@private";
    private static final String PUBLIC_TAG = "@public";
    private final StandardDoclet standardDoclet = new StandardDoclet();
    private final JmxDoclet jmxDoclet = new JmxDoclet();
    private Reporter reporter;
    private Set<String> excludedGenerators = null;

    @Override
    public void init(Locale locale, Reporter reporter) {
        this.reporter = reporter;
        this.standardDoclet.init(locale, reporter);
        this.jmxDoclet.init(locale, reporter);
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Set<? extends Doclet.Option> getSupportedOptions() {
        HashSet<Doclet.Option> options = new HashSet<Doclet.Option>();
        options.addAll(this.standardDoclet.getSupportedOptions());
        options.addAll(this.jmxDoclet.getSupportedOptions());
        options.add(new LambdaOption(1, "Exclude code generated by specific generators", Doclet.Option.Kind.STANDARD, Collections.singletonList(EXCLUDE_GENERATED_BY), "(*|<class1>[,<class2>...])", (opt, args) -> {
            this.excludedGenerators = Arrays.stream(((String)args.get(0)).split("[,]")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
            if (this.excludedGenerators.contains("*")) {
                this.excludedGenerators = Collections.emptySet();
            } else if (this.excludedGenerators.isEmpty()) {
                this.excludedGenerators = null;
            }
            return true;
        }));
        return options;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return this.standardDoclet.getSupportedSourceVersion();
    }

    private boolean isPublicAPI(DocletEnvironment env, Element e) {
        Objects.requireNonNull(env);
        Objects.requireNonNull(e);
        if (this.isGeneratedByExcludedGenerator(e) || DocletMultiplexer.hasTag(env, e, PRIVATE_TAG)) {
            return false;
        }
        if (e instanceof ModuleElement) {
            return true;
        }
        if (DocletMultiplexer.hasTag(env, e, PUBLIC_TAG)) {
            return !DocletMultiplexer.isMarkedPrivate(env, e);
        }
        Element enclosingElement = e.getEnclosingElement();
        if (enclosingElement != null) {
            return this.isPublicAPI(env, enclosingElement);
        }
        return false;
    }

    private static boolean isMarkedPrivate(DocletEnvironment env, Element e) {
        if (DocletMultiplexer.hasTag(env, e, PRIVATE_TAG)) {
            return true;
        }
        Element enclosingElement = e.getEnclosingElement();
        return enclosingElement != null && DocletMultiplexer.isMarkedPrivate(env, enclosingElement);
    }

    private static boolean hasTag(DocletEnvironment env, Element e, String tag) {
        String docComment = env.getElementUtils().getDocComment(e);
        if (docComment == null) {
            return false;
        }
        int pos = docComment.indexOf(tag);
        if (pos == -1) {
            return false;
        }
        int after = pos + tag.length();
        return after == docComment.length() || Character.isWhitespace(docComment.charAt(after));
    }

    private static String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    @Override
    public boolean run(DocletEnvironment environment) {
        DocletEnvironment proxyEnv;
        boolean result = this.jmxDoclet.run(environment);
        try {
            this.filterUnmodifiableSet(environment.getSpecifiedElements(), e -> this.filterElement(environment, (Element)e));
            this.filterUnmodifiableSet(environment.getIncludedElements(), e -> this.filterElement(environment, (Element)e));
        }
        catch (Exception ex) {
            this.reporter.print(Diagnostic.Kind.ERROR, "Failed to filter element set");
            this.reporter.print(Diagnostic.Kind.ERROR, DocletMultiplexer.getStackTraceAsString(ex));
        }
        try {
            proxyEnv = this.makeDocletEnvironmentProxy(environment);
        }
        catch (Exception ex) {
            this.reporter.print(Diagnostic.Kind.ERROR, "Failed to proxify DocletEnvironment");
            this.reporter.print(Diagnostic.Kind.ERROR, DocletMultiplexer.getStackTraceAsString(ex));
            proxyEnv = environment;
        }
        return result &= this.standardDoclet.run(proxyEnv);
    }

    private boolean filterElement(DocletEnvironment env, Element e) {
        boolean result = this.isPublicAPI(env, e);
        return result;
    }

    private boolean isGeneratedByExcludedGenerator(Element e) {
        Set<String> generatedBy;
        if (this.excludedGenerators != null && !(generatedBy = this.getGeneratedBy(e)).isEmpty()) {
            if (this.excludedGenerators.isEmpty()) {
                return true;
            }
            for (String codeGeneratorFQN : generatedBy) {
                if (!this.excludedGenerators.contains(codeGeneratorFQN)) continue;
                return true;
            }
        }
        return false;
    }

    private Set<String> getGeneratedBy(Element e) {
        HashSet<String> generatedBy = new HashSet<String>();
        for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
            String name = annotationMirror.getAnnotationType().toString();
            if (!name.equals("javax.annotation.processing.Generated") && !name.equals("javax.annotation.Generated")) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!entry.getKey().getSimpleName().toString().equals("value")) continue;
                for (AnnotationValue av : (List)entry.getValue().getValue()) {
                    generatedBy.add(av.getValue().toString());
                }
            }
        }
        return generatedBy;
    }

    private <X> void filterUnmodifiableSet(Set<? extends X> unmodifiableSet, Predicate<X> predicate) throws Exception {
        Class<?> zeeClazz = unmodifiableSet.getClass();
        Field c = zeeClazz.getSuperclass().getDeclaredField("c");
        c.setAccessible(true);
        Set innerSet = (Set)c.get(unmodifiableSet);
        HashSet toRemove = new HashSet();
        for (Object e : innerSet) {
            if (predicate.test(e)) continue;
            toRemove.add(e);
        }
        innerSet.removeAll(toRemove);
    }

    private DocletEnvironment makeDocletEnvironmentProxy(DocletEnvironment environment) throws Exception {
        Class<?> envImplClass = environment.getClass();
        HashMap fieldsByType = new HashMap();
        for (Field f : envImplClass.getDeclaredFields()) {
            f.setAccessible(true);
            Object v = f.get(environment);
            if (v == null) continue;
            fieldsByType.put(f.getType(), v);
        }
        Optional<Constructor> maxCtor = Arrays.stream(envImplClass.getDeclaredConstructors()).max(Comparator.comparingInt(Constructor::getParameterCount));
        Class<?>[] paramTypes = maxCtor.get().getParameterTypes();
        Object[] paramValues = new Object[paramTypes.length];
        for (int i = 0; i < paramValues.length; ++i) {
            paramValues[i] = fieldsByType.get(paramTypes[i]);
        }
        DocletEnvironmentInterceptor interceptor = new DocletEnvironmentInterceptor(environment);
        Class proxyClass = new ByteBuddy().subclass(envImplClass).method(ElementMatchers.named("isIncluded")).intercept(MethodDelegation.to(interceptor)).method(ElementMatchers.named("isSelected")).intercept(MethodDelegation.to(interceptor)).make().load(this.getClass().getClassLoader()).getLoaded();
        Constructor ctor = proxyClass.getConstructor(paramTypes);
        return (DocletEnvironment)ctor.newInstance(paramValues);
    }

    public final class DocletEnvironmentInterceptor {
        private final DocletEnvironment original;

        DocletEnvironmentInterceptor(DocletEnvironment original) {
            this.original = original;
        }

        public boolean isIncluded(Element e) {
            return this.original.isIncluded(e) && DocletMultiplexer.this.filterElement(this.original, e);
        }

        public boolean isSelected(Element e) {
            return this.original.isSelected(e) && DocletMultiplexer.this.filterElement(this.original, e);
        }
    }
}

