/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.doclets.jmx;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.standard.Standard;
import com.sun.tools.javadoc.Main;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import org.infinispan.doclets.jmx.JmxComponent;
import org.infinispan.doclets.jmx.JmxHtmlGenerator;
import org.infinispan.doclets.jmx.MBeanAttribute;
import org.infinispan.doclets.jmx.MBeanComponent;
import org.infinispan.doclets.jmx.MBeanOperation;

public class JmxDoclet {
    public static final String MANAGED_ATTRIBUTE_CLASSNAME = "org.infinispan.jmx.annotations.ManagedAttribute";
    public static final String MANAGED_OPERATION_CLASSNAME = "org.infinispan.jmx.annotations.ManagedOperation";
    public static final String MBEAN_CLASSNAME = "org.infinispan.jmx.annotations.MBean";
    private static String outputDirectory;
    private static String encoding;
    private static String bottom;
    private static String footer;
    private static String header;
    private static String title;

    public static void main(String[] args) {
        String name = JmxDoclet.class.getName();
        Main.execute((String)name, (String)name, (String[])args);
    }

    public static boolean start(RootDoc root) throws IOException {
        ClassDoc[] classes = root.classes();
        LinkedList<MBeanComponent> mbeans = new LinkedList<MBeanComponent>();
        for (ClassDoc cd : classes) {
            MBeanComponent mbean = JmxDoclet.toJmxComponent(cd);
            if (mbean == null) continue;
            mbeans.add(mbean);
        }
        Collections.sort(mbeans);
        JmxHtmlGenerator generator = new JmxHtmlGenerator(JmxDoclet.jmxTitle(), "JMX components exposed by Infinispan", "JMX, Infinispan, Data Grids, Documentation, Reference, MBeans, Management, Console", mbeans);
        generator.generateHtml(new File(outputDirectory, "jmxComponents.html").getAbsolutePath());
        return true;
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    public static int optionLength(String option) {
        return Standard.optionLength((String)option);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        for (String[] option : options) {
            if (option[0].equals("-d")) {
                outputDirectory = option[1];
                continue;
            }
            if (option[0].equals("-encoding")) {
                encoding = option[1];
                continue;
            }
            if (option[0].equals("-bottom")) {
                bottom = option[1];
                continue;
            }
            if (option[0].equals("-footer")) {
                footer = option[1];
                continue;
            }
            if (option[0].equals("-header")) {
                header = option[1];
                continue;
            }
            if (!option[0].equals("-doctitle")) continue;
            title = option[1];
        }
        return true;
    }

    private static String jmxTitle() {
        String s = "JMX Components";
        if (title == null || title.length() == 0) {
            return s;
        }
        s = s + " (" + title + ")";
        return s;
    }

    private static MBeanComponent toJmxComponent(ClassDoc cd) {
        MBeanAttribute attr;
        String annotationName;
        boolean isMBean = false;
        MBeanComponent mbc = new MBeanComponent(cd.qualifiedName(), cd.typeName());
        for (AnnotationDesc annotationDesc : cd.annotations()) {
            AnnotationTypeDoc atd = annotationDesc.annotationType();
            String annotationName2 = atd.qualifiedTypeName();
            if (!annotationName2.equals(MBEAN_CLASSNAME)) continue;
            isMBean = true;
            JmxDoclet.setNameDesc(annotationDesc.elementValues(), (JmxComponent)mbc);
        }
        for (AnnotationDesc annotationDesc : cd.methods()) {
            for (AnnotationDesc a : annotationDesc.annotations()) {
                annotationName = a.annotationType().qualifiedTypeName();
                if (annotationName.equals(MANAGED_OPERATION_CLASSNAME)) {
                    isMBean = true;
                    MBeanOperation o = mbc.operations.computeIfAbsent(annotationDesc.name(), name -> new MBeanOperation(name));
                    JmxDoclet.setNameDesc(a.elementValues(), (JmxComponent)o);
                    o.returnType = annotationDesc.returnType().simpleTypeName();
                    for (Parameter p : annotationDesc.parameters()) {
                        o.addParam(p.type().simpleTypeName(), p.name());
                    }
                    continue;
                }
                if (!annotationName.equals(MANAGED_ATTRIBUTE_CLASSNAME)) continue;
                isMBean = true;
                attr = mbc.attributes.computeIfAbsent(JmxDoclet.fromBeanConvention(annotationDesc.name()), name -> new MBeanAttribute(name));
                if (annotationDesc.name().startsWith("get") || annotationDesc.name().startsWith("is")) {
                    attr.type = annotationDesc.returnType().simpleTypeName();
                } else if (annotationDesc.parameters().length > 0) {
                    attr.type = annotationDesc.parameters()[0].type().simpleTypeName();
                }
                JmxDoclet.setNameDesc(a.elementValues(), (JmxComponent)attr);
                JmxDoclet.setWritable(a.elementValues(), attr);
            }
        }
        for (AnnotationDesc annotationDesc : cd.fields(false)) {
            for (AnnotationDesc a : annotationDesc.annotations()) {
                annotationName = a.annotationType().qualifiedTypeName();
                if (!annotationName.equals(MANAGED_ATTRIBUTE_CLASSNAME)) continue;
                isMBean = true;
                attr = mbc.attributes.computeIfAbsent(annotationDesc.name(), name -> new MBeanAttribute(name));
                attr.type = annotationDesc.type().simpleTypeName();
                JmxDoclet.setNameDesc(a.elementValues(), (JmxComponent)attr);
                JmxDoclet.setWritable(a.elementValues(), attr);
            }
        }
        if (isMBean) {
            return mbc;
        }
        return null;
    }

    private static String fromBeanConvention(String getterOrSetter) {
        if (getterOrSetter.startsWith("get") || getterOrSetter.startsWith("set")) {
            String withoutGet = getterOrSetter.substring(4);
            return Character.toUpperCase(getterOrSetter.charAt(3)) + withoutGet;
        }
        if (getterOrSetter.startsWith("is")) {
            String withoutIs = getterOrSetter.substring(3);
            return Character.toUpperCase(getterOrSetter.charAt(2)) + withoutIs;
        }
        return getterOrSetter;
    }

    private static void setNameDesc(AnnotationDesc.ElementValuePair[] evps, JmxComponent mbc) {
        for (AnnotationDesc.ElementValuePair evp : evps) {
            if (!evp.element().name().equals("description")) continue;
            mbc.desc = evp.value().value().toString();
        }
    }

    private static void setWritable(AnnotationDesc.ElementValuePair[] evps, MBeanAttribute attr) {
        for (AnnotationDesc.ElementValuePair evp : evps) {
            if (!evp.element().name().equals("writable")) continue;
            attr.writable = (Boolean)evp.value().value();
        }
    }
}

