/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.doclets.jmx;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.util.DocTrees;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import org.infinispan.doclets.LambdaOption;
import org.infinispan.doclets.jmx.JmxComponent;
import org.infinispan.doclets.jmx.JmxHtmlGenerator;
import org.infinispan.doclets.jmx.MBeanAttribute;
import org.infinispan.doclets.jmx.MBeanComponent;
import org.infinispan.doclets.jmx.MBeanOperation;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JmxDoclet
implements Doclet {
    public static final String MANAGED_ATTRIBUTE_CLASSNAME = "org.infinispan.jmx.annotations.ManagedAttribute";
    public static final String MANAGED_OPERATION_CLASSNAME = "org.infinispan.jmx.annotations.ManagedOperation";
    public static final String MBEAN_CLASSNAME = "org.infinispan.jmx.annotations.MBean";
    static String outputDirectory;
    static String title;

    private static String jmxTitle() {
        Object s = "JMX Components";
        if (title == null || title.length() == 0) {
            return s;
        }
        s = (String)s + " (" + title + ")";
        return s;
    }

    private static MBeanComponent fromMXBeanInterface(TypeElement cd, DocTrees docTrees) {
        MBeanComponent mbc = new MBeanComponent(cd.getQualifiedName().toString(), cd.getSimpleName().toString());
        mbc.desc = JmxDoclet.docTreeToText(docTrees.getDocCommentTree(cd));
        cd.getEnclosedElements().stream().forEach(e -> {
            if (e instanceof ExecutableElement) {
                ExecutableElement ee = (ExecutableElement)e;
                String methodName = ee.getSimpleName().toString();
                if (methodName.startsWith("get") || methodName.startsWith("is")) {
                    MBeanAttribute attr = mbc.attributes.computeIfAbsent(JmxDoclet.fromBeanConvention(methodName), name -> new MBeanAttribute((String)name));
                    attr.type = ee.getReturnType().toString();
                    attr.desc = JmxDoclet.docTreeToText(docTrees.getDocCommentTree((Element)e));
                } else if (methodName.startsWith("set")) {
                    MBeanAttribute attr = mbc.attributes.computeIfAbsent(JmxDoclet.fromBeanConvention(methodName), name -> new MBeanAttribute((String)name));
                    attr.writable = true;
                } else {
                    MBeanOperation o = mbc.operations.computeIfAbsent(ee.getSimpleName().toString(), name -> new MBeanOperation((String)name));
                    o.returnType = JmxDoclet.getTypeName(ee.getReturnType());
                    o.desc = JmxDoclet.docTreeToText(docTrees.getDocCommentTree((Element)e));
                    for (VariableElement variableElement : ee.getParameters()) {
                        o.addParam(JmxDoclet.getTypeName(variableElement.asType()), variableElement.getSimpleName().toString());
                    }
                }
            }
        });
        return mbc;
    }

    private static String docTreeToText(DocCommentTree commentTree) {
        StringBuilder sb = new StringBuilder();
        if (commentTree != null) {
            commentTree.getFullBody().stream().forEach(d -> sb.append(d.toString()));
        }
        return sb.toString();
    }

    private static MBeanComponent fromMBeanAnnotations(TypeElement cd, AnnotationMirror am) {
        String objectName = JmxDoclet.getAnnotationValue(am, "objectName", cd.getSimpleName().toString());
        MBeanComponent mbc = new MBeanComponent(cd.getQualifiedName().toString(), objectName);
        mbc.desc = JmxDoclet.getAnnotationValue(am, "description", "");
        cd.getEnclosedElements().stream().forEach(e -> {
            block8: {
                block7: {
                    if (!(e instanceof ExecutableElement)) break block7;
                    ExecutableElement ee = (ExecutableElement)e;
                    for (AnnotationMirror annotationMirror : ee.getAnnotationMirrors()) {
                        String annotationName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
                        if (annotationName.equals(MANAGED_OPERATION_CLASSNAME)) {
                            MBeanOperation o = mbc.operations.computeIfAbsent(ee.getSimpleName().toString(), name -> new MBeanOperation((String)name));
                            JmxDoclet.setNameDesc(annotationMirror.getElementValues(), o);
                            o.returnType = JmxDoclet.getTypeName(ee.getReturnType());
                            for (VariableElement variableElement : ee.getParameters()) {
                                o.addParam(JmxDoclet.getTypeName(variableElement.asType()), variableElement.getSimpleName().toString());
                            }
                            continue;
                        }
                        if (!annotationName.equals(MANAGED_ATTRIBUTE_CLASSNAME)) continue;
                        String methodName = ee.getSimpleName().toString();
                        MBeanAttribute attr = mbc.attributes.computeIfAbsent(JmxDoclet.fromBeanConvention(methodName), name -> new MBeanAttribute((String)name));
                        if (methodName.startsWith("get") || methodName.startsWith("is")) {
                            attr.type = ee.getReturnType().toString();
                        } else if (ee.getParameters().size() > 0) {
                            attr.type = ee.getParameters().get(0).getSimpleName().toString();
                        }
                        JmxDoclet.setNameDesc(annotationMirror.getElementValues(), attr);
                        JmxDoclet.setWritable(annotationMirror.getElementValues(), attr);
                    }
                    break block8;
                }
                if (!(e instanceof VariableElement)) break block8;
                VariableElement ve = (VariableElement)e;
                for (AnnotationMirror annotationMirror : ve.getAnnotationMirrors()) {
                    String annotationName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
                    if (!annotationName.equals(MANAGED_ATTRIBUTE_CLASSNAME)) continue;
                    MBeanAttribute attr = mbc.attributes.computeIfAbsent(ve.getSimpleName().toString(), name -> new MBeanAttribute((String)name));
                    attr.type = JmxDoclet.getTypeName(ve.asType());
                    JmxDoclet.setNameDesc(annotationMirror.getElementValues(), attr);
                    JmxDoclet.setWritable(annotationMirror.getElementValues(), attr);
                }
            }
        });
        return mbc;
    }

    private static MBeanComponent toJmxComponent(TypeElement cd, DocTrees docTrees) {
        String className = cd.getQualifiedName().toString();
        if (className.endsWith("MXBean")) {
            return JmxDoclet.fromMXBeanInterface(cd, docTrees);
        }
        for (AnnotationMirror annotationMirror : cd.getAnnotationMirrors()) {
            DeclaredType atd = annotationMirror.getAnnotationType();
            String annotationName = atd.toString();
            if (!annotationName.equals(MBEAN_CLASSNAME)) continue;
            return JmxDoclet.fromMBeanAnnotations(cd, annotationMirror);
        }
        return null;
    }

    private static String fromBeanConvention(String getterOrSetter) {
        if (getterOrSetter.startsWith("get") || getterOrSetter.startsWith("set")) {
            String withoutGet = getterOrSetter.substring(4);
            return Character.toUpperCase(getterOrSetter.charAt(3)) + withoutGet;
        }
        if (getterOrSetter.startsWith("is")) {
            String withoutIs = getterOrSetter.substring(3);
            return Character.toUpperCase(getterOrSetter.charAt(2)) + withoutIs;
        }
        return getterOrSetter;
    }

    private static String getAnnotationValue(AnnotationMirror a, String name, String defaultValue) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> evp : a.getElementValues().entrySet()) {
            String annotatioName = evp.getKey().getSimpleName().toString();
            if (!name.equals(annotatioName)) continue;
            return evp.getValue().getValue().toString();
        }
        return defaultValue;
    }

    private static void setNameDesc(Map<? extends ExecutableElement, ? extends AnnotationValue> evps, JmxComponent mbc) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> evp : evps.entrySet()) {
            String name;
            switch (name = evp.getKey().getSimpleName().toString()) {
                case "description": {
                    mbc.desc = evp.getValue().getValue().toString();
                }
            }
        }
    }

    private static void setWritable(Map<? extends ExecutableElement, ? extends AnnotationValue> evps, MBeanAttribute attr) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> evp : evps.entrySet()) {
            if (!evp.getKey().getSimpleName().toString().equals("writable")) continue;
            attr.writable = (Boolean)evp.getValue().getValue();
        }
    }

    @Override
    public void init(Locale locale, Reporter reporter) {
    }

    @Override
    public String getName() {
        return "JMX Doclet";
    }

    @Override
    public Set<? extends Doclet.Option> getSupportedOptions() {
        Doclet.Option[] options = new Doclet.Option[]{new LambdaOption(1, "Doc Title", Doclet.Option.Kind.STANDARD, Collections.singletonList("-doctitle"), "string", (opt, args) -> {
            title = (String)args.get(0);
            return true;
        }), new LambdaOption(1, "Output Directory", Doclet.Option.Kind.STANDARD, Collections.singletonList("-d"), "directory", (opt, args) -> {
            outputDirectory = (String)args.get(0);
            return true;
        })};
        return new HashSet<Doclet.Option>(Arrays.asList(options));
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_8;
    }

    @Override
    public boolean run(DocletEnvironment docletEnvironment) {
        DocTrees docTrees = docletEnvironment.getDocTrees();
        List<MBeanComponent> mbeans = docletEnvironment.getIncludedElements().stream().filter(e -> e instanceof TypeElement).map(e -> (TypeElement)e).map(e -> JmxDoclet.toJmxComponent(e, docTrees)).filter(e -> e != null).collect(Collectors.toList());
        Collections.sort(mbeans);
        JmxHtmlGenerator generator = new JmxHtmlGenerator(JmxDoclet.jmxTitle(), "JMX components", "JMX, Infinispan, Data Grids, Documentation, Reference, MBeans, Management, Console", mbeans);
        try {
            generator.generateHtml(new File(outputDirectory, "jmxComponents.html").getAbsolutePath());
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        return true;
    }

    private static String getTypeName(TypeMirror t) {
        return t.toString();
    }
}

