/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hadoop.sample.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.hadoop.sample.util.Argument;

public class ControllerCache {
    public static void main(String[] args) throws Exception {
        EnumMap<Argument, String> map = new EnumMap<Argument, String>(Argument.class);
        LinkedList<String> queue = new LinkedList<String>(Arrays.asList(args));
        Argument.setDefaultValues(map);
        while (!queue.isEmpty()) {
            Argument.parse(queue, map);
        }
        if (map.containsKey((Object)Argument.HELP)) {
            System.out.println("The following arguments are allowed:");
            for (Argument argument : Argument.values()) {
                System.out.println(Argument.help(argument));
            }
            System.exit(0);
        } else if (map.containsKey((Object)Argument.POPULATE)) {
            System.exit(ControllerCache.executeOnCache(new CopyFile(), map));
        } else if (map.containsKey((Object)Argument.DUMP)) {
            System.exit(ControllerCache.executeOnCache(new DumpCache(), map));
        } else if (map.containsKey((Object)Argument.CLEAR)) {
            System.exit(ControllerCache.executeOnCache(new ClearCache(), map));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K, V> int executeOnCache(RemoteCacheRunnable<K, V> runnable, Map<Argument, String> map) throws Exception {
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(map.get((Object)Argument.HOST), Integer.parseInt(map.get((Object)Argument.PORT)));
        RemoteCache remoteCache = remoteCacheManager.getCache(map.get((Object)Argument.CACHE_NAME));
        try {
            if (remoteCache == null) {
                System.err.println("Unable to connect to cache");
                int n = -1;
                return n;
            }
            int n = runnable.execute(remoteCache, map);
            return n;
        }
        finally {
            if (remoteCache != null) {
                remoteCache.stop();
            }
            remoteCacheManager.stop();
        }
    }

    private static ExecutorService executorService() {
        return new ThreadPoolExecutor(1, Runtime.getRuntime().availableProcessors() * 2, 10L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    private static class ClearCache
    implements RemoteCacheRunnable<Object, Object> {
        private ClearCache() {
        }

        @Override
        public int execute(RemoteCache<Object, Object> remoteCache, Map<Argument, String> map) throws Exception {
            remoteCache.clear();
            return 0;
        }
    }

    private static class DumpCache
    implements RemoteCacheRunnable<Object, Object> {
        private DumpCache() {
        }

        @Override
        public int execute(RemoteCache<Object, Object> remoteCache, Map<Argument, String> map) throws Exception {
            try (CloseableIterator closeableIterator = remoteCache.retrieveEntries(null, 2000);){
                while (closeableIterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)closeableIterator.next();
                    System.out.println(entry.getKey() + "\t" + entry.getValue());
                }
            }
            return 0;
        }
    }

    private static class CopyFile
    implements RemoteCacheRunnable<Integer, String> {
        private CopyFile() {
        }

        @Override
        public int execute(final RemoteCache<Integer, String> remoteCache, Map<Argument, String> map) throws Exception {
            String line;
            String filePath = map.get((Object)Argument.FILE);
            if (filePath == null) {
                System.err.println(Argument.FILE.getArg() + " is missing!");
                return 1;
            }
            File file = new File(filePath);
            if (!file.exists()) {
                System.err.println("File '" + filePath + "' not found!");
                return 1;
            }
            BufferedReader reader = new BufferedReader(new FileReader(file));
            ExecutorService executorService = ControllerCache.executorService();
            int lineNumber = 1;
            while ((line = reader.readLine()) != null) {
                final String finalLine = line;
                final int finalLineNumber = lineNumber++;
                executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        remoteCache.put((Object)finalLineNumber, (Object)finalLine);
                        if (finalLineNumber % 1000 == 0) {
                            System.out.println("Line " + finalLineNumber + " added by " + Thread.currentThread());
                        }
                    }
                });
            }
            reader.close();
            executorService.shutdown();
            while (!executorService.awaitTermination(1L, TimeUnit.MINUTES)) {
            }
            return 0;
        }
    }

    public static interface RemoteCacheRunnable<K, V> {
        public int execute(RemoteCache<K, V> var1, Map<Argument, String> var2) throws Exception;
    }
}

