/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.iteration;

import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.iteration.KeyTracker;
import org.infinispan.client.hotrod.impl.iteration.KeyTrackerFactory;
import org.infinispan.client.hotrod.impl.operations.IterationEndResponse;
import org.infinispan.client.hotrod.impl.operations.IterationNextOperation;
import org.infinispan.client.hotrod.impl.operations.IterationNextResponse;
import org.infinispan.client.hotrod.impl.operations.IterationStartOperation;
import org.infinispan.client.hotrod.impl.operations.IterationStartResponse;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.CloseableIterator;

@NotThreadSafe
public class RemoteCloseableIterator
implements CloseableIterator<Map.Entry<Object, Object>> {
    private static final Log log = LogFactory.getLog(RemoteCloseableIterator.class);
    private final OperationsFactory operationsFactory;
    private final Marshaller marshaller;
    private final String filterConverterFactory;
    private final Set<Integer> segments;
    private final int batchSize;
    private KeyTracker segmentKeyTracker;
    private Transport transport;
    private String iterationId;
    boolean endOfIteration = false;
    private Queue<AbstractMap.SimpleEntry<Object, Object>> nextElements = new LinkedList<AbstractMap.SimpleEntry<Object, Object>>();

    public RemoteCloseableIterator(OperationsFactory operationsFactory, String filterConverterFactory, Set<Integer> segments, int batchSize, Marshaller marshaller) {
        this.filterConverterFactory = filterConverterFactory;
        this.segments = segments;
        this.batchSize = batchSize;
        this.operationsFactory = operationsFactory;
        this.marshaller = marshaller;
    }

    @Override
    public void close() {
        IterationEndResponse endResponse = this.operationsFactory.newIterationEndOperation(this.iterationId, this.transport).execute();
        short status = endResponse.getStatus();
        if (status == 0) {
            log.iterationClosed(this.iterationId);
        }
        if (endResponse.getStatus() == 5) {
            throw log.errorClosingIteration(this.iterationId);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.nextElements.isEmpty()) {
            this.fetch();
        }
        return !this.endOfIteration;
    }

    @Override
    public Map.Entry<Object, Object> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.nextElements.remove();
    }

    private void fetch() {
        try {
            IterationNextOperation iterationNextOperation = this.operationsFactory.newIterationNextOperation(this.iterationId, this.transport);
            while (this.nextElements.isEmpty() && !this.endOfIteration) {
                IterationNextResponse iterationNextResponse = iterationNextOperation.execute();
                short status = iterationNextResponse.getStatus();
                if (status == 5) {
                    throw log.errorRetrievingNext(this.iterationId);
                }
                Map.Entry<byte[], byte[]>[] entries = iterationNextResponse.getEntries();
                if (entries.length == 0) {
                    this.endOfIteration = true;
                    break;
                }
                for (Map.Entry<byte[], byte[]> entry : entries) {
                    if (!this.segmentKeyTracker.track(entry.getKey())) continue;
                    this.nextElements.add(new AbstractMap.SimpleEntry<Object, Object>(this.unmarshall(entry.getKey()), this.unmarshall(entry.getValue())));
                }
                this.segmentKeyTracker.segmentsFinished(iterationNextResponse.getFinishedSegments());
            }
        }
        catch (TransportException e) {
            log.warnf((Throwable)e, "Error reaching the server during iteration", new Object[0]);
            this.restartIteration(this.segmentKeyTracker.missedSegments());
            this.fetch();
        }
    }

    private Object unmarshall(byte[] bytes) {
        return MarshallerUtil.bytes2obj(this.marshaller, bytes);
    }

    private void restartIteration(Set<Integer> missedSegments) {
        this.startInternal(missedSegments);
    }

    private void start(Set<Integer> fromSegments) {
        IterationStartResponse startResponse = this.startInternal(fromSegments);
        this.segmentKeyTracker = KeyTrackerFactory.create(startResponse.getSegmentConsistentHash(), startResponse.getTopologyId());
    }

    private IterationStartResponse startInternal(Set<Integer> fromSegments) {
        if (log.isDebugEnabled()) {
            log.debugf("Staring iteration with segments %s", (Object)fromSegments);
        }
        IterationStartOperation iterationStartOperation = this.operationsFactory.newIterationStartOperation(this.filterConverterFactory, fromSegments, this.batchSize);
        IterationStartResponse startResponse = (IterationStartResponse)iterationStartOperation.execute();
        this.transport = startResponse.getTransport();
        if (log.isDebugEnabled()) {
            log.debugf("Obtained transport", (Object)this.transport);
        }
        this.iterationId = startResponse.getIterationId();
        if (log.isDebugEnabled()) {
            log.debugf("IterationId:", (Object)this.iterationId);
        }
        return startResponse;
    }

    public void start() {
        this.start(this.segments);
    }
}

