/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import java.util.Arrays;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryExpiredEvent;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.impl.protocol.Codec20;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;

public class Codec21
extends Codec20 {
    private static final Log log = LogFactory.getLog(Codec21.class, Log.class);

    @Override
    public Log getLog() {
        return log;
    }

    @Override
    public HeaderParams writeHeader(Transport transport, HeaderParams params) {
        return this.writeHeader(transport, params, (byte)21);
    }

    @Override
    public void writeClientListenerParams(Transport transport, ClientListener clientListener, byte[][] filterFactoryParams, byte[][] converterFactoryParams) {
        super.writeClientListenerParams(transport, clientListener, filterFactoryParams, converterFactoryParams);
        transport.writeByte((short)(clientListener.useRawData() ? 1 : 0));
    }

    @Override
    protected ClientEvent readPartialEvent(Transport transport, byte[] expectedListenerId, Marshaller marshaller, short eventTypeId) {
        boolean isRetried;
        ClientEvent.Type eventType;
        short status = transport.readByte();
        transport.readByte();
        switch (eventTypeId) {
            case 96: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED;
                break;
            }
            case 97: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED;
                break;
            }
            case 98: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED;
                break;
            }
            case 99: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_EXPIRED;
                break;
            }
            case 80: {
                this.checkForErrorsInResponseStatus(transport, null, status);
            }
            default: {
                throw log.unknownEvent(eventTypeId);
            }
        }
        byte[] listenerId = transport.readArray();
        if (!Arrays.equals(listenerId, expectedListenerId)) {
            throw log.unexpectedListenerId(Util.printArray(listenerId), Util.printArray(expectedListenerId));
        }
        short isCustom = transport.readByte();
        boolean bl = isRetried = transport.readByte() == 1;
        if (isCustom == 1) {
            Object eventData = MarshallerUtil.bytes2obj(marshaller, transport.readArray());
            return this.createCustomEvent(eventData, eventType, isRetried);
        }
        if (isCustom == 2) {
            return this.createCustomEvent(transport.readArray(), eventType, isRetried);
        }
        switch (eventType) {
            case CLIENT_CACHE_ENTRY_CREATED: {
                Object createdKey = MarshallerUtil.bytes2obj(marshaller, transport.readArray());
                long createdDataVersion = transport.readLong();
                return this.createCreatedEvent(createdKey, createdDataVersion, isRetried);
            }
            case CLIENT_CACHE_ENTRY_MODIFIED: {
                Object modifiedKey = MarshallerUtil.bytes2obj(marshaller, transport.readArray());
                long modifiedDataVersion = transport.readLong();
                return this.createModifiedEvent(modifiedKey, modifiedDataVersion, isRetried);
            }
            case CLIENT_CACHE_ENTRY_REMOVED: {
                Object removedKey = MarshallerUtil.bytes2obj(marshaller, transport.readArray());
                return this.createRemovedEvent(removedKey, isRetried);
            }
            case CLIENT_CACHE_ENTRY_EXPIRED: {
                Object expiredKey = MarshallerUtil.bytes2obj(marshaller, transport.readArray());
                return this.createExpiredEvent(expiredKey);
            }
        }
        throw this.getLog().unknownEvent(eventTypeId);
    }

    protected ClientEvent createExpiredEvent(final Object key) {
        return new ClientCacheEntryExpiredEvent(){

            public Object getKey() {
                return key;
            }

            @Override
            public ClientEvent.Type getType() {
                return ClientEvent.Type.CLIENT_CACHE_ENTRY_EXPIRED;
            }

            public String toString() {
                return "ClientCacheEntryExpiredEvent(key=" + key + ")";
            }
        };
    }
}

