/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hadoop;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.infinispan.hadoop.InfinispanSplitter;
import org.infinispan.hadoop.KeyValueConverter;
import org.infinispan.hadoop.impl.DefaultSplitter;

public final class InfinispanConfiguration {
    public static final int DEFAULT_READ_BATCH_SIZE = 5000;
    public static final int DEFAULT_WRITE_BATCH_SIZE = 500;
    public static final String INPUT_FILTER_FACTORY = "hadoop.ispn.input.filter.factory";
    public static final String INPUT_REMOTE_CACHE_NAME = "hadoop.ispn.input.cache.name";
    public static final String INPUT_REMOTE_CACHE_HOST = "hadoop.ispn.input.remote.cache.host";
    public static final String INPUT_REMOTE_CACHE_PORT = "hadoop.ispn.input.remote.cache.port";
    public static final String OUTPUT_REMOTE_CACHE_NAME = "hadoop.ispn.output.cache.name";
    public static final String OUTPUT_REMOTE_CACHE_HOST = "hadoop.ispn.output.remote.cache.host";
    public static final String OUTPUT_REMOTE_CACHE_PORT = "hadoop.ispn.output.remote.cache.port";
    public static final String SERIALIZATION_CLASSES = "hadoop.ispn.io.serialization.classes";
    public static final String INPUT_READ_BATCH_SIZE = "hadoop.ispn.input.read.batch";
    public static final String OUTPUT_WRITE_BATCH_SIZE = "hadoop.ispn.output.write.batch";
    public static final String INPUT_KEY_VALUE_CONVERTER = "hadoop.ispn.input.converter";
    public static final String OUTPUT_KEY_VALUE_CONVERTER = "hadoop.ispn.output.converter";
    public static final String SPLITTER_CLASS = "hadoop.ispn.input.splitter.class";
    private final Configuration configuration;

    public InfinispanConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getInputCacheName() {
        return this.configuration.get(INPUT_REMOTE_CACHE_NAME, "___defaultcache");
    }

    public String getOutputCacheName() {
        return this.configuration.get(OUTPUT_REMOTE_CACHE_NAME, "___defaultcache");
    }

    public String getInputRemoteCacheHost() {
        return this.configuration.get(INPUT_REMOTE_CACHE_HOST, "localhost");
    }

    public int getInputRemoteCachePort() {
        return this.configuration.getInt(INPUT_REMOTE_CACHE_PORT, 11222);
    }

    public String getOutputRemoteCacheHost() {
        return this.configuration.get(OUTPUT_REMOTE_CACHE_HOST, "localhost");
    }

    public int getOutputRemoteCachePort() {
        return this.configuration.getInt(OUTPUT_REMOTE_CACHE_PORT, 11222);
    }

    public String getInputFilterFactory() {
        return this.configuration.get(INPUT_FILTER_FACTORY);
    }

    public Integer getReadBatchSize() {
        return this.configuration.getInt(INPUT_READ_BATCH_SIZE, 5000);
    }

    public Integer getWriteBatchSize() {
        return this.configuration.getInt(OUTPUT_WRITE_BATCH_SIZE, 500);
    }

    public InfinispanSplitter getSplitter() throws IOException {
        String splitterClass = this.configuration.get(SPLITTER_CLASS);
        if (splitterClass == null) {
            return new DefaultSplitter();
        }
        return (InfinispanSplitter)this.getInstance(splitterClass);
    }

    public <K1, K2, V1, V2> KeyValueConverter<K1, K2, V1, V2> getInputConverter() throws IOException {
        return (KeyValueConverter)this.getInstance(this.configuration.get(INPUT_KEY_VALUE_CONVERTER));
    }

    public <K1, K2, V1, V2> KeyValueConverter<K1, K2, V1, V2> getOutputConverter() throws IOException {
        return (KeyValueConverter)this.getInstance(this.configuration.get(OUTPUT_KEY_VALUE_CONVERTER));
    }

    private <T> T getInstance(String className) throws IOException {
        if (className != null) {
            try {
                return (T)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return null;
    }
}

