/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hadoop;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.hadoop.InfinispanConfiguration;
import org.infinispan.hadoop.InfinispanSplitter;
import org.infinispan.hadoop.KeyValueConverter;
import org.infinispan.hadoop.impl.ConvertingRecordReader;
import org.infinispan.hadoop.impl.InfinispanCache;
import org.infinispan.hadoop.impl.InfinispanRecordReader;

public class InfinispanInputFormat<K, V>
extends InputFormat<K, V> {
    public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
        Configuration configuration = jobContext.getConfiguration();
        InfinispanConfiguration infinispanConfiguration = new InfinispanConfiguration(configuration);
        InfinispanCache inputCache = InfinispanCache.getInputCache(infinispanConfiguration);
        InfinispanSplitter splitter = infinispanConfiguration.getSplitter();
        return splitter.calculateSplits(inputCache.getCacheTopology());
    }

    public RecordReader<K, V> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        Configuration configuration = taskAttemptContext.getConfiguration();
        InfinispanConfiguration infinispanConfiguration = new InfinispanConfiguration(configuration);
        String inputFilterFactory = infinispanConfiguration.getInputFilterFactory();
        Integer readBatchSize = infinispanConfiguration.getReadBatchSize();
        InfinispanCache inputCache = InfinispanCache.getInputCache(infinispanConfiguration);
        RemoteCache remoteCache = inputCache.getRemoteCache();
        KeyValueConverter inputConverter = infinispanConfiguration.getInputConverter();
        InfinispanRecordReader recordReader = new InfinispanRecordReader(remoteCache, inputFilterFactory, readBatchSize);
        if (inputConverter == null) {
            return recordReader;
        }
        return new ConvertingRecordReader(recordReader, inputConverter);
    }
}

