/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hadoop.impl;

import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.hadoop.InfinispanConfiguration;
import org.infinispan.hadoop.impl.PreferredServerBalancingStrategy;

public class InfinispanCache<K, V> {
    private static Log log = LogFactory.getLog(InfinispanCache.class);
    private final RemoteCacheManager remoteCacheManager;
    private final RemoteCache<K, V> remoteCache;

    private InfinispanCache(RemoteCacheManager remoteCacheManager, RemoteCache<K, V> remoteCache) {
        this.remoteCacheManager = remoteCacheManager;
        this.remoteCache = remoteCache;
    }

    public void stop() {
        if (this.remoteCache != null) {
            this.remoteCache.stop();
        }
        if (this.remoteCacheManager != null) {
            this.remoteCacheManager.stop();
        }
    }

    public RemoteCache<K, V> getRemoteCache() {
        return this.remoteCache;
    }

    public static <K, V> InfinispanCache<K, V> getInputCache(InfinispanConfiguration configuration) {
        return InfinispanCache.getCache(configuration.getInputRemoteCacheHost(), configuration.getInputRemoteCachePort(), configuration.getInputCacheName());
    }

    public static <K, V> InfinispanCache<K, V> getOutputCache(InfinispanConfiguration configuration) {
        return InfinispanCache.getCache(configuration.getOutputRemoteCacheHost(), configuration.getOutputRemoteCachePort(), configuration.getOutputCacheName());
    }

    private static <K, V> InfinispanCache<K, V> getCache(String host, int port, String name) {
        log.info((Object)("Connecting to cache " + name + " in [" + host + ":" + port + "]"));
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.addServer().host(host).port(port).balancingStrategy(new PreferredServerBalancingStrategy(InetSocketAddress.createUnresolved(host, port)));
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(configurationBuilder.build());
        BasicCache remoteCache = remoteCacheManager.getCache(name);
        return new InfinispanCache<K, V>(remoteCacheManager, remoteCache);
    }

    public String toString() {
        return "InfinispanCache{remoteCacheManager=" + this.remoteCacheManager + ", remoteCache=" + this.remoteCache + '}';
    }

    public CacheTopologyInfo getCacheTopology() {
        return this.remoteCache.getCacheTopologyInfo();
    }
}

