/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hadoop.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.infinispan.client.hotrod.RemoteCache;

public class InfinispanRecordWriter<K, V>
extends RecordWriter<K, V> {
    private final RemoteCache<K, V> remoteCache;
    private final int writeBatchSize;
    private final Map<K, V> batch;

    public InfinispanRecordWriter(RemoteCache<K, V> remoteCache, int writeBatchSize) {
        this.remoteCache = remoteCache;
        this.writeBatchSize = writeBatchSize;
        this.batch = new HashMap(writeBatchSize);
    }

    public void write(K key, V value) throws IOException, InterruptedException {
        this.batch.put(key, value);
        if (this.batch.size() >= this.writeBatchSize) {
            this.remoteCache.putAll(this.batch);
            this.batch.clear();
        }
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        if (!this.batch.isEmpty()) {
            this.remoteCache.putAll(this.batch);
        }
        this.remoteCache.getRemoteCacheManager().stop();
    }
}

