/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hadoop.sample.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedList;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.hadoop.sample.util.Argument;

public class WordCounterPopulator {
    public static void main(String[] args) throws Exception {
        String line;
        File file;
        String filePath;
        EnumMap<Argument, String> map = new EnumMap<Argument, String>(Argument.class);
        LinkedList<String> queue = new LinkedList<String>(Arrays.asList(args));
        Argument.setDefaultValues(map);
        while (!queue.isEmpty()) {
            Argument.parse(queue, map);
        }
        if (map.containsKey((Object)Argument.HELP)) {
            System.out.println("The following arguments are allowed:");
            for (Argument argument : Argument.values()) {
                System.out.println(Argument.help(argument));
            }
            System.exit(0);
        }
        if ((filePath = (String)map.get((Object)Argument.FILE)) == null) {
            System.err.println(Argument.FILE.getArg() + " is missing!");
            System.exit(1);
        }
        if (!(file = new File(filePath)).exists()) {
            System.err.println("File '" + filePath + "' not found!");
            System.exit(1);
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager((String)map.get((Object)Argument.HOST), Integer.parseInt((String)map.get((Object)Argument.PORT)));
        BasicCache remoteCache = remoteCacheManager.getCache((String)map.get((Object)Argument.CACHE_NAME));
        int lineNumber = 1;
        System.out.println();
        while ((line = reader.readLine()) != null) {
            remoteCache.put(lineNumber++, line);
            if (lineNumber % 100 != 0) continue;
            System.out.printf("\rLine " + lineNumber + " added!", new Object[0]);
        }
        System.out.println();
        reader.close();
        remoteCache.stop();
        remoteCacheManager.stop();
        System.exit(0);
    }
}

