/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hadoop.impl;

import java.io.IOException;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.infinispan.hadoop.KeyValueConverter;

public class ConvertingRecordReader<K1, V1, K, V>
extends RecordReader<K, V> {
    private final RecordReader<K1, V1> recordReader;
    private final KeyValueConverter<K1, V1, K, V> keyValueConverter;

    public ConvertingRecordReader(RecordReader<K1, V1> recordReader, KeyValueConverter<K1, V1, K, V> keyValueConverter) {
        this.recordReader = recordReader;
        this.keyValueConverter = keyValueConverter;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        this.recordReader.initialize(split, context);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.recordReader.nextKeyValue();
    }

    public K getCurrentKey() throws IOException, InterruptedException {
        return this.keyValueConverter.convertKey(this.recordReader.getCurrentKey());
    }

    public V getCurrentValue() throws IOException, InterruptedException {
        return this.keyValueConverter.convertValue(this.recordReader.getCurrentValue());
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.recordReader.getProgress();
    }

    public void close() throws IOException {
        this.recordReader.close();
    }
}

