/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hadoop;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.infinispan.hadoop.InfinispanConfiguration;
import org.infinispan.hadoop.KeyValueConverter;
import org.infinispan.hadoop.impl.ConvertingRecordWriter;
import org.infinispan.hadoop.impl.InfinispanCache;
import org.infinispan.hadoop.impl.InfinispanRecordWriter;

public class InfinispanOutputFormat<K, V>
extends OutputFormat<K, V> {
    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration configuration = context.getConfiguration();
        InfinispanConfiguration infinispanConfiguration = new InfinispanConfiguration(configuration);
        Integer writeBatchSize = infinispanConfiguration.getWriteBatchSize();
        KeyValueConverter outputConverter = infinispanConfiguration.getOutputConverter();
        InfinispanCache outputCache = InfinispanCache.getOutputCache(infinispanConfiguration);
        InfinispanRecordWriter<Object, Object> recordWriter = new InfinispanRecordWriter<Object, Object>(outputCache.getRemoteCache(), writeBatchSize);
        if (outputConverter == null) {
            return recordWriter;
        }
        return new ConvertingRecordWriter(recordWriter, outputConverter);
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new OutputCommitter(){

            public void setupJob(JobContext jobContext) throws IOException {
            }

            public void setupTask(TaskAttemptContext taskContext) throws IOException {
            }

            public boolean needsTaskCommit(TaskAttemptContext taskContext) throws IOException {
                return false;
            }

            public void commitTask(TaskAttemptContext taskContext) throws IOException {
            }

            public void abortTask(TaskAttemptContext taskContext) throws IOException {
            }
        };
    }
}

