/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hadoop.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.mapreduce.InputSplit;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.hadoop.InfinispanSplitter;
import org.infinispan.hadoop.impl.InfinispanInputSplit;

public final class DefaultSplitter
implements InfinispanSplitter {
    @Override
    public List<InputSplit> calculateSplits(CacheTopologyInfo cacheTopologyInfo) throws IOException {
        Map segmentsPerServer = cacheTopologyInfo.getSegmentsPerServer();
        int numServers = segmentsPerServer.keySet().size();
        if (segmentsPerServer.isEmpty()) {
            throw new IOException("No servers found to partition");
        }
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        if (numServers == 1) {
            SocketAddress server = (SocketAddress)segmentsPerServer.keySet().iterator().next();
            splits.add(new InfinispanInputSplit((Set)segmentsPerServer.get(server), ((InetSocketAddress)server).getHostName()));
            return splits;
        }
        Set servers = segmentsPerServer.keySet();
        int numSegments = cacheTopologyInfo.getNumSegments();
        HashSet<Integer> takenSegments = new HashSet<Integer>();
        HashMap partitions = new HashMap();
        while (takenSegments.size() != numSegments) {
            int beforeSize = takenSegments.size();
            for (SocketAddress server : servers) {
                Set ownedSegments = (Set)segmentsPerServer.get(server);
                if (ownedSegments.isEmpty()) continue;
                Iterator iterator = ownedSegments.iterator();
                boolean match = false;
                while (iterator.hasNext() && !match) {
                    Integer segment = (Integer)iterator.next();
                    if (takenSegments.contains(segment)) continue;
                    Set<Integer> partitionSegments = partitions.containsKey(server) ? (Set)partitions.get(server) : new HashSet();
                    partitionSegments.add(segment);
                    partitions.put(server, partitionSegments);
                    takenSegments.add(segment);
                    match = true;
                }
            }
            if (takenSegments.size() != beforeSize) continue;
            break;
        }
        for (Map.Entry entry : partitions.entrySet()) {
            splits.add(new InfinispanInputSplit((Set)entry.getValue(), ((InetSocketAddress)entry.getKey()).getHostName()));
        }
        return splits;
    }
}

