/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hadoop.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.InputSplit;

public class InfinispanInputSplit
extends InputSplit
implements Writable {
    private String preferredLocation;
    private Set<Integer> segments = new HashSet<Integer>();

    public InfinispanInputSplit(Set<Integer> segments, String preferredLocation) {
        this.segments.addAll(segments);
        this.preferredLocation = preferredLocation;
    }

    public InfinispanInputSplit() {
    }

    public long getLength() throws IOException, InterruptedException {
        return 0L;
    }

    public String[] getLocations() throws IOException, InterruptedException {
        return new String[]{this.preferredLocation};
    }

    public Set<Integer> getSegments() {
        return this.segments;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.preferredLocation);
        WritableUtils.writeVInt((DataOutput)out, (int)this.segments.size());
        for (Integer segment : this.segments) {
            WritableUtils.writeVInt((DataOutput)out, (int)segment);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.preferredLocation = Text.readString((DataInput)in);
        int segmentSize = WritableUtils.readVInt((DataInput)in);
        for (int i = 0; i < segmentSize; ++i) {
            this.segments.add(WritableUtils.readVInt((DataInput)in));
        }
    }
}

