/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hadoop.impl;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Set;
import org.infinispan.client.hotrod.impl.transport.tcp.FailoverRequestBalancingStrategy;
import org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy;

public class PreferredServerBalancingStrategy
implements FailoverRequestBalancingStrategy {
    private final InetSocketAddress preferredServer;
    private final RoundRobinBalancingStrategy roundRobin = new RoundRobinBalancingStrategy();

    public PreferredServerBalancingStrategy(InetSocketAddress preferredServer) {
        this.preferredServer = preferredServer;
    }

    public void setServers(Collection<SocketAddress> servers) {
        this.roundRobin.setServers(servers);
    }

    private boolean isValid(InetSocketAddress server) {
        for (SocketAddress socketAddress : this.roundRobin.getServers()) {
            if (!socketAddress.equals(server)) continue;
            return true;
        }
        return false;
    }

    public SocketAddress nextServer() {
        return this.roundRobin.nextServer(null);
    }

    public SocketAddress nextServer(Set<SocketAddress> failedServers) {
        if (failedServers != null && failedServers.contains(this.preferredServer) || !this.isValid(this.preferredServer)) {
            return this.roundRobin.nextServer(failedServers);
        }
        return this.preferredServer;
    }
}

