/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hadoop.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;

public class JBossMarshallerSerialization<T>
implements Serialization<T>,
Configurable {
    private Configuration conf;
    private GenericJBossMarshaller marshaller = new GenericJBossMarshaller();

    public boolean accept(Class<?> c) {
        Configuration conf = this.getConf();
        String[] classes = conf.getTrimmedStrings("hadoop.ispn.io.serialization.classes");
        if (classes == null || classes.length == 0) {
            return false;
        }
        for (String clazz : classes) {
            if (!clazz.equals(c.getName())) continue;
            return true;
        }
        return false;
    }

    public Serializer<T> getSerializer(Class<T> c) {
        return new MarshallerSerializer(this.marshaller);
    }

    public Deserializer<T> getDeserializer(Class<T> c) {
        return new MarshallerDeserializer(this.marshaller);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    private static class MarshallerDeserializer<T>
    implements Deserializer<T> {
        private final GenericJBossMarshaller marshaller;
        private InputStream inputStream;

        public MarshallerDeserializer(GenericJBossMarshaller marshaller) {
            this.marshaller = marshaller;
        }

        public void open(InputStream in) throws IOException {
            this.inputStream = in;
        }

        public void close() throws IOException {
            this.marshaller.stop();
        }

        public T deserialize(Object o) throws IOException {
            ObjectInput objectInput = this.marshaller.startObjectInput(this.inputStream, false);
            try {
                Object object = this.marshaller.objectFromObjectStream(objectInput);
                return (T)object;
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            finally {
                this.marshaller.finishObjectInput(objectInput);
            }
        }
    }

    private static class MarshallerSerializer<T>
    implements Serializer<T> {
        private final GenericJBossMarshaller marshaller;
        private OutputStream out;

        public MarshallerSerializer(GenericJBossMarshaller marshaller) {
            this.marshaller = marshaller;
        }

        public void open(OutputStream out) throws IOException {
            this.out = out;
        }

        public void serialize(T o) throws IOException {
            ObjectOutput objectOutput = this.marshaller.startObjectOutput(this.out, false, 512);
            try {
                this.marshaller.objectToObjectStream(o, objectOutput);
            }
            finally {
                this.marshaller.finishObjectOutput(objectOutput);
            }
        }

        public void close() throws IOException {
            this.marshaller.stop();
        }
    }
}

