/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hadoop.impl;

import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.transport.tcp.FailoverRequestBalancingStrategy;
import org.infinispan.hadoop.InfinispanConfiguration;
import org.infinispan.hadoop.impl.PreferredServerBalancingStrategy;

public class InfinispanCache<K, V> {
    private static Log log = LogFactory.getLog(InfinispanCache.class);
    private final RemoteCacheManager remoteCacheManager;
    private final RemoteCache<K, V> remoteCache;

    private InfinispanCache(RemoteCacheManager remoteCacheManager, RemoteCache<K, V> remoteCache) {
        this.remoteCacheManager = remoteCacheManager;
        this.remoteCache = remoteCache;
    }

    public void stop() {
        if (this.remoteCache != null) {
            this.remoteCache.stop();
        }
        if (this.remoteCacheManager != null) {
            this.remoteCacheManager.stop();
        }
    }

    public RemoteCache<K, V> getRemoteCache() {
        return this.remoteCache;
    }

    public static <K, V> InfinispanCache<K, V> getInputCache(InfinispanConfiguration configuration, InetSocketAddress preferredServer) {
        return InfinispanCache.getCache(configuration.getInputCacheName(), configuration.getInputRemoteCacheServerList(), preferredServer);
    }

    public static <K, V> InfinispanCache<K, V> getOutputCache(InfinispanConfiguration configuration, InetSocketAddress preferredServer) {
        return InfinispanCache.getCache(configuration.getOutputCacheName(), configuration.getOutputRemoteCacheServerList(), preferredServer);
    }

    private static <K, V> InfinispanCache<K, V> getCache(String name, String serverList, InetSocketAddress preferredServer) {
        log.info((Object)("Connecting to cache " + name + " in [" + serverList + "]"));
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.addServers(serverList);
        if (preferredServer != null) {
            configurationBuilder.balancingStrategy((FailoverRequestBalancingStrategy)new PreferredServerBalancingStrategy(preferredServer));
        }
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(configurationBuilder.build());
        RemoteCache remoteCache = remoteCacheManager.getCache(name);
        return new InfinispanCache<K, V>(remoteCacheManager, remoteCache);
    }

    public String toString() {
        return "InfinispanCache{remoteCacheManager=" + this.remoteCacheManager + ", remoteCache=" + this.remoteCache + '}';
    }

    public CacheTopologyInfo getCacheTopology() {
        return this.remoteCache.getCacheTopologyInfo();
    }
}

