/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hadoop.impl;

import java.io.IOException;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.infinispan.hadoop.KeyValueConverter;

public class ConvertingRecordWriter<K, V>
extends RecordWriter<K, V> {
    private final RecordWriter<Object, Object> recordWriter;
    private final KeyValueConverter<Object, Object, K, V> keyValueConverter;

    public ConvertingRecordWriter(RecordWriter<Object, Object> recordWriter, KeyValueConverter<Object, Object, K, V> keyValueConverter) {
        this.recordWriter = recordWriter;
        this.keyValueConverter = keyValueConverter;
    }

    public void write(K key, V value) throws IOException, InterruptedException {
        this.recordWriter.write(this.keyValueConverter.convertKey(key), this.keyValueConverter.convertValue(value));
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        this.recordWriter.close(context);
    }
}

