/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hadoop.impl;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.hadoop.impl.InfinispanInputSplit;

public class InfinispanRecordReader<K, V>
extends RecordReader<K, V> {
    private CloseableIterator<Map.Entry<Object, Object>> entryIterator;
    private K currentKey;
    private V currentValue;
    private RemoteCache<K, V> remoteCache;
    private final String filterFactory;
    private final Integer readBatchSize;

    public InfinispanRecordReader(RemoteCache<K, V> remoteCache, String filterFactory, int readBatchSize) {
        this.remoteCache = remoteCache;
        this.filterFactory = filterFactory;
        this.readBatchSize = readBatchSize;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        InfinispanInputSplit infinispanInputSplit = (InfinispanInputSplit)split;
        this.entryIterator = this.remoteCache.retrieveEntries(this.filterFactory, infinispanInputSplit.getSegments(), this.readBatchSize.intValue());
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (!this.entryIterator.hasNext()) {
            return false;
        }
        Map.Entry nextEntry = (Map.Entry)this.entryIterator.next();
        this.currentKey = nextEntry.getKey();
        this.currentValue = nextEntry.getValue();
        return true;
    }

    public K getCurrentKey() throws IOException, InterruptedException {
        return this.currentKey;
    }

    public V getCurrentValue() throws IOException, InterruptedException {
        return this.currentValue;
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.entryIterator.hasNext() ? 0.0f : 1.0f;
    }

    public void close() throws IOException {
        this.entryIterator.close();
        this.remoteCache.getRemoteCacheManager().stop();
    }

    public RemoteCache<K, V> getRemoteCache() {
        return this.remoteCache;
    }
}

