/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.Evaluator;
import io.quarkus.qute.EvaluatorImpl;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.Parser;
import io.quarkus.qute.PublisherFactory;
import io.quarkus.qute.ResultMapper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.Variant;
import io.quarkus.qute.WithPriority;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jboss.logging.Logger;

class EngineImpl
implements Engine {
    private static final Logger LOGGER = Logger.getLogger(EngineImpl.class);
    private final Map<String, SectionHelperFactory<?>> sectionHelperFactories;
    private final Function<String, SectionHelperFactory<?>> sectionHelperFunc;
    private final List<ValueResolver> valueResolvers;
    private final List<NamespaceResolver> namespaceResolvers;
    private final Evaluator evaluator;
    private final Map<String, Template> templates;
    private final List<TemplateLocator> locators;
    private final List<ResultMapper> resultMappers;
    private final PublisherFactory publisherFactory;
    private final AtomicLong idGenerator = new AtomicLong(0L);

    EngineImpl(Map<String, SectionHelperFactory<?>> sectionHelperFactories, List<ValueResolver> valueResolvers, List<NamespaceResolver> namespaceResolvers, List<TemplateLocator> locators, List<ResultMapper> resultMappers, Function<String, SectionHelperFactory<?>> sectionHelperFunc) {
        this.sectionHelperFactories = Collections.unmodifiableMap(new HashMap(sectionHelperFactories));
        this.valueResolvers = EngineImpl.sort(valueResolvers);
        this.namespaceResolvers = ImmutableList.copyOf(namespaceResolvers);
        this.evaluator = new EvaluatorImpl(this.valueResolvers);
        this.templates = new ConcurrentHashMap<String, Template>();
        this.locators = EngineImpl.sort(locators);
        ServiceLoader<PublisherFactory> loader = ServiceLoader.load(PublisherFactory.class);
        Iterator<PublisherFactory> iterator = loader.iterator();
        this.publisherFactory = iterator.hasNext() ? iterator.next() : null;
        if (iterator.hasNext()) {
            throw new IllegalStateException("Multiple reactive factories found: " + StreamSupport.stream(loader.spliterator(), false).map(Object::getClass).map(Class::getName).collect(Collectors.joining(",")));
        }
        this.resultMappers = EngineImpl.sort(resultMappers);
        this.sectionHelperFunc = sectionHelperFunc;
    }

    @Override
    public Template parse(String content, Variant variant) {
        String generatedId = this.generateId();
        return new Parser(this).parse(new StringReader(content), Optional.ofNullable(variant), generatedId, generatedId);
    }

    @Override
    public SectionHelperFactory<?> getSectionHelperFactory(String name) {
        SectionHelperFactory<?> factory = this.sectionHelperFactories.get(name);
        if (factory != null) {
            return factory;
        }
        return this.sectionHelperFunc != null ? this.sectionHelperFunc.apply(name) : null;
    }

    @Override
    public Map<String, SectionHelperFactory<?>> getSectionHelperFactories() {
        return this.sectionHelperFactories;
    }

    @Override
    public List<ValueResolver> getValueResolvers() {
        return this.valueResolvers;
    }

    @Override
    public List<NamespaceResolver> getNamespaceResolvers() {
        return this.namespaceResolvers;
    }

    @Override
    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    @Override
    public List<ResultMapper> getResultMappers() {
        return this.resultMappers;
    }

    @Override
    public Template putTemplate(String id, Template template) {
        return this.templates.put(id, template);
    }

    @Override
    public Template getTemplate(String id) {
        return this.templates.computeIfAbsent(id, this::load);
    }

    @Override
    public void clearTemplates() {
        this.templates.clear();
    }

    @Override
    public void removeTemplates(Predicate<String> test) {
        this.templates.keySet().removeIf(test);
    }

    PublisherFactory getPublisherFactory() {
        return this.publisherFactory;
    }

    String generateId() {
        return "" + this.idGenerator.incrementAndGet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Template load(String id) {
        Iterator<TemplateLocator> iterator = this.locators.iterator();
        while (iterator.hasNext()) {
            TemplateLocator locator = iterator.next();
            Optional<TemplateLocator.TemplateLocation> location = locator.locate(id);
            if (!location.isPresent()) continue;
            try (Reader r = location.get().read();){
                Template template = new Parser(this).parse(this.ensureBufferedReader(r), location.get().getVariant(), id, this.generateId());
                return template;
            }
            catch (IOException e) {
                LOGGER.warn((Object)("Unable to close the reader for " + id), e);
            }
        }
        return null;
    }

    private static <T extends WithPriority> List<T> sort(Collection<T> items) {
        ArrayList<T> sorted = new ArrayList<T>(items);
        sorted.sort(Comparator.comparingInt(WithPriority::getPriority).reversed());
        return ImmutableList.copyOf(sorted);
    }

    private Reader ensureBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? reader : new BufferedReader(reader);
    }
}

