/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Expression;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.Mapper;
import io.quarkus.qute.MultiResultNode;
import io.quarkus.qute.Parameter;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Results;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.TemplateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class LoopSectionHelper
implements SectionHelper {
    private static final String DEFAULT_ALIAS = "it";
    private final String alias;
    private final Expression iterable;

    LoopSectionHelper(String alias, Expression iterable) {
        this.alias = "$empty$".equals(alias) ? DEFAULT_ALIAS : alias;
        this.iterable = Objects.requireNonNull(iterable);
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        return context.resolutionContext().evaluate(this.iterable).thenCompose(it -> {
            if (it == null) {
                throw new TemplateException(String.format("Loop section error in template %s on line %s: [%s] resolved to [null] which is not iterable", this.iterable.getOrigin().getTemplateId(), this.iterable.getOrigin().getLine(), this.iterable.toOriginalString()));
            }
            ArrayList<CompletionStage<ResultNode>> results = new ArrayList<CompletionStage<ResultNode>>();
            Iterator<?> iterator = this.extractIterator(it);
            int idx = 0;
            while (iterator.hasNext()) {
                results.add(this.nextElement(iterator.next(), idx++, iterator.hasNext(), context));
            }
            if (results.isEmpty()) {
                return CompletableFuture.completedFuture(ResultNode.NOOP);
            }
            CompletableFuture result = new CompletableFuture();
            CompletableFuture[] all = new CompletableFuture[results.size()];
            idx = 0;
            for (CompletionStage completionStage : results) {
                all[idx++] = completionStage.toCompletableFuture();
            }
            CompletableFuture.allOf(all).whenComplete((v, t) -> {
                if (t != null) {
                    result.completeExceptionally((Throwable)t);
                } else {
                    result.complete(new MultiResultNode(all));
                }
            });
            return result;
        });
    }

    private Iterator<?> extractIterator(Object it) {
        if (it instanceof Iterable) {
            return ((Iterable)it).iterator();
        }
        if (it instanceof Iterator) {
            return (Iterator)it;
        }
        if (it instanceof Map) {
            return ((Map)it).entrySet().iterator();
        }
        if (it instanceof Stream) {
            return ((Stream)((Stream)it).sequential()).iterator();
        }
        if (it instanceof Integer) {
            return IntStream.rangeClosed(1, (Integer)it).iterator();
        }
        if (it.getClass().isArray()) {
            return Arrays.stream((Object[])it).iterator();
        }
        throw new TemplateException(String.format("Loop section error in template %s on line %s: [%s] resolved to [%s] which is not iterable", this.iterable.getOrigin().getTemplateId(), this.iterable.getOrigin().getLine(), this.iterable.toOriginalString(), it.getClass().getName()));
    }

    CompletionStage<ResultNode> nextElement(Object element, int index, boolean hasNext, SectionHelper.SectionResolutionContext context) {
        AtomicReference<ResolutionContext> resolutionContextHolder = new AtomicReference<ResolutionContext>();
        ResolutionContext child = context.resolutionContext().createChild(new IterationElement(this.alias, element, index, hasNext), null);
        resolutionContextHolder.set(child);
        return context.execute(child);
    }

    static class IterationElement
    implements Mapper {
        final String alias;
        final Object element;
        final int index;
        final boolean hasNext;

        public IterationElement(String alias, Object element, int index, boolean hasNext) {
            this.alias = alias;
            this.element = element;
            this.index = index;
            this.hasNext = hasNext;
        }

        @Override
        public Object get(String key) {
            if (this.alias.equals(key)) {
                return this.element;
            }
            switch (key) {
                case "count": {
                    return this.index + 1;
                }
                case "index": {
                    return this.index;
                }
                case "indexParity": {
                    return this.index % 2 != 0 ? "even" : "odd";
                }
                case "hasNext": {
                    return this.hasNext;
                }
                case "isOdd": 
                case "odd": {
                    return this.index % 2 == 0;
                }
                case "isEven": 
                case "even": {
                    return this.index % 2 != 0;
                }
            }
            return Results.Result.NOT_FOUND;
        }
    }

    public static class Factory
    implements SectionHelperFactory<LoopSectionHelper> {
        public static final String HINT = "<for-element>";
        private static final String ALIAS = "alias";
        private static final String IN = "in";
        private static final String ITERABLE = "iterable";

        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of("for", "each");
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return SectionHelperFactory.ParametersInfo.builder().addParameter(ALIAS, "$empty$").addParameter(IN, "$empty$").addParameter(new Parameter(ITERABLE, null, true)).build();
        }

        @Override
        public LoopSectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
            return new LoopSectionHelper(context.getParameter(ALIAS), context.getExpression(ITERABLE));
        }

        @Override
        public Map<String, String> initializeBlock(Map<String, String> outerNameTypeInfos, SectionHelperFactory.BlockInfo block) {
            if (block.getLabel().equals("$main")) {
                String iterable = block.getParameters().get(ITERABLE);
                if (iterable == null) {
                    iterable = "this";
                }
                Expression iterableExpr = block.addExpression(ITERABLE, iterable);
                String alias = block.getParameters().get(ALIAS);
                if (iterableExpr.getParts().get(0).getTypeInfo() != null) {
                    alias = alias.equals("$empty$") ? LoopSectionHelper.DEFAULT_ALIAS : alias;
                    HashMap<String, String> typeInfos = new HashMap<String, String>(outerNameTypeInfos);
                    typeInfos.put(alias, iterableExpr.collectTypeInfo() + HINT);
                    return typeInfos;
                }
                HashMap<String, String> typeInfos = new HashMap<String, String>(outerNameTypeInfos);
                typeInfos.put(alias, null);
                return typeInfos;
            }
            return Collections.emptyMap();
        }
    }
}

