/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Expression;
import io.quarkus.qute.Futures;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.Parameter;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class UserTagSectionHelper
implements SectionHelper {
    private static final String IT = "it";
    private final Supplier<Template> templateSupplier;
    private final Map<String, Expression> parameters;

    public UserTagSectionHelper(Supplier<Template> templateSupplier, Map<String, Expression> parameters) {
        this.templateSupplier = templateSupplier;
        this.parameters = parameters;
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        CompletableFuture<ResultNode> result = new CompletableFuture<ResultNode>();
        Futures.evaluateParams(this.parameters, context.resolutionContext()).whenComplete((r1, t1) -> {
            if (t1 != null) {
                result.completeExceptionally((Throwable)t1);
            } else {
                try {
                    TemplateImpl tagTemplate = (TemplateImpl)this.templateSupplier.get();
                    tagTemplate.root.resolve(context.resolutionContext().createChild(r1, null)).whenComplete((r2, t2) -> {
                        if (t2 != null) {
                            result.completeExceptionally((Throwable)t2);
                        } else {
                            result.complete((ResultNode)r2);
                        }
                    });
                }
                catch (Exception e) {
                    result.completeExceptionally(e);
                }
            }
        });
        return result;
    }

    public static class Factory
    implements SectionHelperFactory<UserTagSectionHelper> {
        private final String name;
        private final String templateId;

        public Factory(String name, String templateId) {
            this.name = name;
            this.templateId = templateId;
        }

        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of(this.name);
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return SectionHelperFactory.ParametersInfo.builder().addParameter(new Parameter(UserTagSectionHelper.IT, UserTagSectionHelper.IT, false)).build();
        }

        @Override
        public UserTagSectionHelper initialize(final SectionHelperFactory.SectionInitContext context) {
            Map<String, Expression> params = context.getParameters().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> context.parseValue((String)e.getValue())));
            return new UserTagSectionHelper(new Supplier<Template>(){

                @Override
                public Template get() {
                    Template template = context.getEngine().getTemplate(templateId);
                    if (template == null) {
                        throw new IllegalStateException("Tag template not found: " + templateId);
                    }
                    return template;
                }
            }, params);
        }
    }
}

