/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.runtime.CleanableExecutor;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.ThreadPoolConfig;
import io.quarkus.runtime.annotations.Recorder;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.jboss.threads.EnhancedQueueExecutor;
import org.jboss.threads.JBossExecutors;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.common.cpu.ProcessorInfo;

@Recorder
public class ExecutorRecorder {
    private static final Logger log = Logger.getLogger("io.quarkus.thread-pool");
    static volatile CleanableExecutor devModeExecutor;
    private static volatile Executor current;

    public ExecutorService setupRunTime(ShutdownContext shutdownContext, ThreadPoolConfig threadPoolConfig, LaunchMode launchMode) {
        ExecutorService executor;
        if (devModeExecutor != null) {
            current = devModeExecutor;
            return devModeExecutor;
        }
        EnhancedQueueExecutor underlying = ExecutorRecorder.createExecutor(threadPoolConfig);
        Runnable shutdownTask = ExecutorRecorder.createShutdownTask(threadPoolConfig, underlying);
        if (launchMode == LaunchMode.DEVELOPMENT) {
            devModeExecutor = new CleanableExecutor(underlying);
            shutdownContext.addShutdownTask(new Runnable(){

                @Override
                public void run() {
                    devModeExecutor.clean();
                }
            });
            executor = devModeExecutor;
            Runtime.getRuntime().addShutdownHook(new Thread(shutdownTask, "Executor shutdown thread"));
        } else {
            shutdownContext.addShutdownTask(shutdownTask);
            executor = underlying;
        }
        if (threadPoolConfig.prefill) {
            underlying.prestartAllCoreThreads();
        }
        current = executor;
        return executor;
    }

    public static ExecutorService createDevModeExecutorForFailedStart(ThreadPoolConfig config) {
        EnhancedQueueExecutor underlying = ExecutorRecorder.createExecutor(config);
        Runnable task = ExecutorRecorder.createShutdownTask(config, underlying);
        devModeExecutor = new CleanableExecutor(underlying);
        Runtime.getRuntime().addShutdownHook(new Thread(task, "Executor shutdown thread"));
        current = devModeExecutor;
        return devModeExecutor;
    }

    static void shutdownDevMode() {
        devModeExecutor.shutdown();
    }

    private static Runnable createShutdownTask(final ThreadPoolConfig threadPoolConfig, final EnhancedQueueExecutor executor) {
        return new Runnable(){

            @Override
            public void run() {
                long interval;
                executor.shutdown();
                Duration shutdownTimeout = threadPoolConfig.shutdownTimeout;
                Optional<Duration> optionalInterval = threadPoolConfig.shutdownCheckInterval;
                long remaining = shutdownTimeout.toNanos();
                long intervalRemaining = interval = optionalInterval.orElse(Duration.ofNanos(Long.MAX_VALUE)).toNanos();
                long interruptRemaining = threadPoolConfig.shutdownInterrupt.toNanos();
                long start = System.nanoTime();
                while (true) {
                    try {
                        if (!executor.awaitTermination(Math.min(remaining, intervalRemaining), TimeUnit.MILLISECONDS)) {
                            long elapsed = System.nanoTime() - start;
                            intervalRemaining -= elapsed;
                            remaining -= elapsed;
                            if ((interruptRemaining -= elapsed) <= 0L) {
                                executor.shutdown(true);
                            }
                            if (remaining <= 0L) {
                                List<Runnable> runnables = executor.shutdownNow();
                                if (!runnables.isEmpty()) {
                                    log.warnf("Thread pool shutdown failed: discarding %d tasks, %d threads still running", (Object)runnables.size(), (Object)executor.getActiveCount());
                                } else {
                                    log.warnf("Thread pool shutdown failed: %d threads still running", (Object)executor.getActiveCount());
                                }
                                break;
                            }
                            if (intervalRemaining <= 0L) {
                                intervalRemaining = interval;
                                int queueSize = executor.getQueueSize();
                                Thread[] runningThreads = executor.getRunningThreads();
                                log.infof("Awaiting thread pool shutdown; %d thread(s) running with %d task(s) waiting", (Object)runningThreads.length, (Object)queueSize);
                                int realWaiting = runningThreads.length;
                                block3: for (Thread thr : runningThreads) {
                                    StackTraceElement[] stackTrace = thr.getStackTrace();
                                    for (int i = 0; i < stackTrace.length && i < 8; ++i) {
                                        if (!stackTrace[i].getClassName().equals("java.lang.System") || !stackTrace[i].getMethodName().equals("exit")) continue;
                                        Throwable t = new Throwable();
                                        t.setStackTrace(stackTrace);
                                        log.errorf(t, "Thread %s is blocked in System.exit(); pooled (Executor) threads should never call this method because it never returns, thus preventing the thread pool from shutting down in a timely manner.  This is the stack trace of the call", (Object)thr.getName());
                                        --realWaiting;
                                        continue block3;
                                    }
                                }
                                if (realWaiting == 0 && queueSize == 0) {
                                    executor.shutdownNow();
                                    break;
                                }
                            }
                        }
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        };
    }

    private static EnhancedQueueExecutor createExecutor(ThreadPoolConfig threadPoolConfig) {
        JBossThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("executor"), Boolean.TRUE, null, "executor-thread-%t", JBossExecutors.loggingExceptionHandler("org.jboss.executor.uncaught"), null);
        EnhancedQueueExecutor.Builder builder = new EnhancedQueueExecutor.Builder().setRegisterMBean(false).setHandoffExecutor(JBossExecutors.rejectingExecutor()).setThreadFactory(JBossExecutors.resettingThreadFactory(threadFactory));
        int cpus = ProcessorInfo.availableProcessors();
        builder.setCorePoolSize(threadPoolConfig.coreThreads);
        builder.setMaximumPoolSize(threadPoolConfig.maxThreads.orElse(8 * cpus));
        if (threadPoolConfig.queueSize.isPresent()) {
            if (threadPoolConfig.queueSize.getAsInt() < 0) {
                builder.setMaximumQueueSize(Integer.MAX_VALUE);
            } else {
                builder.setMaximumQueueSize(threadPoolConfig.queueSize.getAsInt());
            }
        }
        builder.setGrowthResistance(threadPoolConfig.growthResistance);
        builder.setKeepAliveTime(threadPoolConfig.keepAliveTime);
        return builder.build();
    }

    public static Executor getCurrent() {
        return current;
    }
}

