/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import io.quarkus.runtime.ssl.SslContextConfiguration;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

@TargetClass(className="javax.net.ssl.SSLContext")
public final class Target_javax_net_ssl_SSLContext {
    @Alias
    private static SSLContext defaultContext;

    @Alias
    protected Target_javax_net_ssl_SSLContext(SSLContextSpi contextSpi, Provider provider, String protocol) {
    }

    @Substitute
    public static synchronized SSLContext getDefault() throws NoSuchAlgorithmException {
        if (defaultContext == null) {
            defaultContext = SslContextConfiguration.isSslNativeEnabled() ? SSLContext.getInstance("Default") : new DisabledSSLContext();
        }
        return defaultContext;
    }

    private static class DisabledSSLContextSpi
    extends SSLContextSpi {
        private DisabledSSLContextSpi() {
        }

        @Override
        protected void engineInit(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom) throws KeyManagementException {
        }

        @Override
        protected SSLSocketFactory engineGetSocketFactory() {
            return new SSLSocketFactory(){

                @Override
                public String[] getDefaultCipherSuites() {
                    return new String[0];
                }

                @Override
                public String[] getSupportedCipherSuites() {
                    return new String[0];
                }

                @Override
                public Socket createSocket(Socket socket, String s, int i, boolean b) throws IOException {
                    throw this.sslSupportDisabledException();
                }

                @Override
                public Socket createSocket(String s, int i) throws IOException, UnknownHostException {
                    throw this.sslSupportDisabledException();
                }

                @Override
                public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) throws IOException, UnknownHostException {
                    throw this.sslSupportDisabledException();
                }

                @Override
                public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
                    throw this.sslSupportDisabledException();
                }

                @Override
                public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
                    throw this.sslSupportDisabledException();
                }
            };
        }

        @Override
        protected SSLServerSocketFactory engineGetServerSocketFactory() {
            throw this.sslSupportDisabledException();
        }

        @Override
        protected SSLEngine engineCreateSSLEngine() {
            throw this.sslSupportDisabledException();
        }

        @Override
        protected SSLEngine engineCreateSSLEngine(String s, int i) {
            throw this.sslSupportDisabledException();
        }

        @Override
        protected SSLSessionContext engineGetServerSessionContext() {
            throw this.sslSupportDisabledException();
        }

        @Override
        protected SSLSessionContext engineGetClientSessionContext() {
            throw this.sslSupportDisabledException();
        }

        private RuntimeException sslSupportDisabledException() {
            return new IllegalStateException("Native SSL support is disabled: you have set quarkus.ssl.native to false in your configuration.");
        }
    }

    private static class DisabledSSLContext
    extends SSLContext {
        protected DisabledSSLContext() {
            super(new DisabledSSLContextSpi(), new Provider("DISABLED", 1.0, "DISABLED"){}, "DISABLED");
        }
    }
}

