/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.Converters;
import io.smallrye.config.ImplicitConverters;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntFunction;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public class SmallRyeConfig
implements Config,
Serializable {
    private static final long serialVersionUID = 8138651532357898263L;
    static final Comparator<ConfigSource> CONFIG_SOURCE_COMPARATOR = new Comparator<ConfigSource>(){

        @Override
        public int compare(ConfigSource o1, ConfigSource o2) {
            int res = Integer.compare(o2.getOrdinal(), o1.getOrdinal());
            return res != 0 ? res : o2.getName().compareTo(o1.getName());
        }
    };
    private final AtomicReference<List<ConfigSource>> configSourcesRef;
    private final Map<Type, Converter<?>> converters;
    private final Map<Type, Converter<Optional<?>>> optionalConverters = new ConcurrentHashMap();

    protected SmallRyeConfig(List<ConfigSource> configSources, Map<Type, Converter<?>> converters) {
        this.configSourcesRef = new AtomicReference<List<ConfigSource>>(Collections.unmodifiableList(configSources));
        this.converters = new ConcurrentHashMap(Converters.ALL_CONVERTERS);
        this.converters.putAll(converters);
    }

    public <T, C extends Collection<T>> C getValues(String name, Class<T> itemClass, IntFunction<C> collectionFactory) {
        return this.getValues(name, this.getConverter(itemClass), collectionFactory);
    }

    public <T, C extends Collection<T>> C getValues(String name, Converter<T> converter, IntFunction<C> collectionFactory) {
        return (C)((Collection)this.getValue(name, Converters.newCollectionConverter(converter, collectionFactory)));
    }

    @Override
    public <T> T getValue(String name, Class<T> aClass) {
        return this.getValue(name, this.getConverter(aClass));
    }

    public <T> T getValue(String name, Converter<T> converter) {
        T converted;
        String value = this.getRawValue(name);
        if (value != null) {
            converted = converter.convert(value);
        } else {
            try {
                converted = converter.convert("");
            }
            catch (IllegalArgumentException ignored) {
                throw SmallRyeConfig.propertyNotFound(name);
            }
        }
        if (converted == null) {
            throw SmallRyeConfig.propertyNotFound(name);
        }
        return converted;
    }

    public boolean rawValueEquals(String name, String expected) {
        return Objects.equals(expected, this.getRawValue(name));
    }

    public String getRawValue(String name) {
        for (ConfigSource configSource : this.getConfigSources()) {
            String value = configSource.getValue(name);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public <T> Optional<T> getOptionalValue(String name, Class<T> aClass) {
        return this.getValue(name, this.getOptionalConverter(aClass));
    }

    public <T> Optional<T> getOptionalValue(String name, Converter<T> converter) {
        return this.getValue(name, Converters.newOptionalConverter(converter));
    }

    public <T, C extends Collection<T>> Optional<C> getOptionalValues(String name, Class<T> itemClass, IntFunction<C> collectionFactory) {
        return this.getOptionalValues(name, this.getConverter(itemClass), collectionFactory);
    }

    public <T, C extends Collection<T>> Optional<C> getOptionalValues(String name, Converter<T> converter, IntFunction<C> collectionFactory) {
        return this.getOptionalValue(name, Converters.newCollectionConverter(converter, collectionFactory));
    }

    @Override
    public Iterable<String> getPropertyNames() {
        HashSet<String> names = new HashSet<String>();
        for (ConfigSource configSource : this.getConfigSources()) {
            names.addAll(configSource.getPropertyNames());
        }
        return names;
    }

    @Override
    public Iterable<ConfigSource> getConfigSources() {
        return this.configSourcesRef.get();
    }

    public void addConfigSource(ConfigSource configSource) {
        List<ConfigSource> newVal;
        List<ConfigSource> oldVal;
        do {
            oldVal = this.configSourcesRef.get();
            int oldSize = oldVal.size();
            newVal = Arrays.asList(oldVal.toArray(new ConfigSource[oldSize + 1]));
            newVal.set(oldSize, configSource);
            newVal.sort(CONFIG_SOURCE_COMPARATOR);
        } while (!this.configSourcesRef.compareAndSet(oldVal, Collections.unmodifiableList(newVal)));
    }

    public <T> T convert(String value, Class<T> asType) {
        return value != null ? (T)this.getConverter(asType).convert(value) : null;
    }

    private <T> Converter<Optional<T>> getOptionalConverter(Class<T> asType) {
        return this.optionalConverters.computeIfAbsent(asType, clazz -> Converters.newOptionalConverter(this.getConverter((Class)clazz)));
    }

    public <T> Converter<T> getConverter(Class<T> asType) {
        if (asType.isPrimitive()) {
            return this.getConverter(Converters.wrapPrimitiveType(asType));
        }
        if (asType.isArray()) {
            return Converters.newArrayConverter(this.getConverter(asType.getComponentType()), asType);
        }
        return this.converters.computeIfAbsent(asType, clazz -> {
            Converter conv = ImplicitConverters.getConverter((Class)clazz);
            if (conv == null) {
                throw new IllegalArgumentException("No Converter registered for " + asType);
            }
            return conv;
        });
    }

    private static NoSuchElementException propertyNotFound(String name) {
        return new NoSuchElementException("Property " + name + " not found");
    }
}

