/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.images;

import io.quarkus.qute.RawString;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateExtension;
import io.quarkus.qute.api.ResourcePath;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.infinispan.images.Util;

@ApplicationScoped
public class ConfigGenerator {
    static final String INFINISPAN_FILE = "infinispan.xml";
    static final String LOGGING_FILE = "log4j2.xml";
    static final String JGROUPS_RELAY_FILE = "jgroups-relay.xml";
    @Inject
    Template infinispan;
    @Inject
    @ResourcePath(value="jgroups-relay.xml")
    Template jgroupsRelay;
    @Inject
    Template log4j2;

    void process(File serverConfig, File outputDir) throws Exception {
        Map<String, Object> userConfig = serverConfig == null ? null : Util.loadYaml(serverConfig);
        Map<String, Object> config = Util.loadYamlFromResources("default-config.yaml");
        ((Map)config.get("jgroups")).put("bindAddress", InetAddress.getLocalHost().getHostAddress());
        Util.merge(config, userConfig);
        this.configureKeystore(config, outputDir);
        this.configureJGroupsRelay(config, outputDir);
        this.createFileAndRenderTemplate(outputDir, LOGGING_FILE, config, this.log4j2);
        this.createFileAndRenderTemplate(outputDir, INFINISPAN_FILE, config, this.infinispan);
    }

    void configureJGroupsRelay(Map<String, Object> config, File outputDir) throws Exception {
        List backups = (List)Util.get(config, "xsite.backups");
        if (backups == null) {
            return;
        }
        String remoteSites = backups.stream().map(b -> String.format("%s[%s]", b.get("address"), b.get("port"))).collect(Collectors.joining(","));
        config.put("remoteSites", remoteSites);
        this.createFileAndRenderTemplate(outputDir, JGROUPS_RELAY_FILE, config, this.jgroupsRelay);
    }

    void configureKeystore(Map<String, Object> config, File outputDir) throws Exception {
        Map ks = (Map)config.computeIfAbsent("keystore", k -> new HashMap());
        boolean noPathProvided = List.of("path", "crtPath").stream().noneMatch(ks::containsKey);
        if (noPathProvided) {
            boolean selfSign = (Boolean)Util.get(config, "keystore.selfSignCert");
            if (selfSign) {
                ks.put("password", "infinispan");
                ks.put("path", new File(outputDir, "selfsigned_keystore.p12").getAbsolutePath());
                ks.put("alias", "server");
            }
            return;
        }
        ks.put("selfSignCert", "false");
        String path = (String)ks.get("path");
        File ksRoot = path != null && !path.trim().isEmpty() ? new File(path).getParentFile() : new File(outputDir, "keystores");
        ksRoot.mkdirs();
        String crtPath = (String)ks.get("crtPath");
        if (crtPath != null && !crtPath.trim().isEmpty()) {
            ks.putIfAbsent("path", new File(ksRoot, "keystore.p12").getPath());
            String type = ((String)ks.get("type")).toLowerCase();
            File keystore = new File(ksRoot, "keystore." + type);
            String password = ks.computeIfAbsent("password", k -> "infinispan");
            char[] ksPass = password.toCharArray();
            String[] cmd = List.of("openssl", "pkcs12", "-export", "-inkey", new File(crtPath, "tls.key").getPath(), "-in", new File(crtPath, "tls.crt").getPath(), "-out", keystore.getPath(), "-name", (String)ks.get("alias"), "-password", "pass:" + password).toArray(new String[0]);
            Util.exec(cmd);
            KeyStore keyStore = KeyStore.getInstance(type);
            try (FileInputStream is = new FileInputStream(keystore);){
                keyStore.load(is, ksPass);
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            List<String> certs = ConfigGenerator.parseCAFile((String)ks.get("caFile"));
            for (int i = 0; i < certs.size(); ++i) {
                String alias = "service-crt-" + (Serializable)(i < 10 ? "0" + i : Integer.valueOf(i));
                byte[] bytes = certs.get(i).getBytes(StandardCharsets.UTF_8);
                try (InputStream is = Base64.getDecoder().wrap(new ByteArrayInputStream(bytes));){
                    keyStore.setCertificateEntry(alias, cf.generateCertificate(is));
                    continue;
                }
            }
            try (FileOutputStream os = new FileOutputStream(keystore);){
                keyStore.store(os, ksPass);
            }
        }
    }

    static List<String> parseCAFile(String path) throws IOException {
        ArrayList<String> certs = new ArrayList<String>();
        if (path == null || path.trim().isEmpty()) {
            return certs;
        }
        StringBuilder sb = new StringBuilder();
        for (String line : Files.readAllLines(Paths.get(path, new String[0]))) {
            if (line.isEmpty() || line.contains("BEGIN CERTIFICATE")) continue;
            if (line.contains("END CERTIFICATE")) {
                certs.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            sb.append(line);
        }
        return certs;
    }

    void createFileAndRenderTemplate(File outputDir, String fileName, Object data, Template template) throws IOException {
        Path filePath = new File(outputDir, fileName).toPath();
        Files.writeString(filePath, (CharSequence)template.data(data).render(), new OpenOption[0]);
    }

    @TemplateExtension
    static String upperCase(String value) {
        return value == null ? null : value.toUpperCase();
    }

    @TemplateExtension
    static String stack(String transport) {
        return "image" + transport;
    }

    @TemplateExtension
    static RawString listElement(List<String> list, String elementName) {
        String element = list == null || list.isEmpty() ? "" : String.format("<%1$s>%2$s</%1$s>", elementName, String.join((CharSequence)",", list));
        return new RawString(element);
    }
}

