/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import java.util.HashMap;
import java.util.Map;

public class Scope {
    public static final Scope EMPTY = new Scope(null){

        @Override
        public void put(String binding, String type) {
            throw new UnsupportedOperationException("Immutable empty scope");
        }
    };
    private Scope parentScope;
    private Map<String, String> bindings;

    public Scope(Scope parentScope) {
        this.parentScope = parentScope;
    }

    public void put(String binding, String type) {
        if (this.bindings == null) {
            this.bindings = new HashMap<String, String>();
        }
        this.bindings.put(binding, type);
    }

    public String getBindingType(String binding) {
        if (this.bindings != null && this.bindings.containsKey(binding)) {
            return this.bindings.get(binding);
        }
        return this.parentScope != null ? this.parentScope.getBindingType(binding) : null;
    }

    public String getBindingTypeOrDefault(String binding, String defaultValue) {
        String type = this.getBindingType(binding);
        return type != null ? type : defaultValue;
    }
}

