/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.BackPressureFailure;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.mutiny.subscription.SerializedSubscriber;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.reactivestreams.Subscription;

public final class MultiBufferWithTimeoutOp<T>
extends AbstractMultiOperator<T, List<T>> {
    private final int size;
    private final Supplier<List<T>> supplier;
    private final ScheduledExecutorService scheduler;
    private final Duration timeout;

    public MultiBufferWithTimeoutOp(Multi<T> upstream, int size, Duration timeout, ScheduledExecutorService scheduler) {
        super(upstream);
        this.timeout = ParameterValidation.validate(timeout, "timeout");
        this.size = ParameterValidation.positive(size, "size");
        this.scheduler = ParameterValidation.nonNull(scheduler, "scheduler");
        this.supplier = () -> {
            if (size < Integer.MAX_VALUE) {
                return new ArrayList(size);
            }
            return new ArrayList();
        };
    }

    @Override
    public void subscribe(MultiSubscriber<? super List<T>> downstream) {
        MultiBufferWithTimeoutProcessor<T> subscriber = new MultiBufferWithTimeoutProcessor<T>(new SerializedSubscriber<List<T>>(downstream), this.size, this.timeout, this.scheduler, this.supplier);
        this.upstream.subscribe().withSubscriber(subscriber);
    }

    static class MultiBufferWithTimeoutProcessor<T>
    extends MultiOperatorProcessor<T, List<T>> {
        private static final int RUNNING = 0;
        private static final int SUCCEED = 1;
        private static final int FAILED = 2;
        private static final int CANCELLED = 3;
        private final int size;
        private final Duration duration;
        private final ScheduledExecutorService executor;
        private final Supplier<List<T>> supplier;
        private final Runnable flush;
        private AtomicInteger terminated = new AtomicInteger(0);
        private AtomicLong requested = new AtomicLong();
        private AtomicInteger index = new AtomicInteger();
        private List<T> current;
        private ScheduledFuture<?> task;

        MultiBufferWithTimeoutProcessor(MultiSubscriber<? super List<T>> downstream, int size, Duration timeout, ScheduledExecutorService executor, Supplier<List<T>> supplier) {
            super(downstream);
            this.duration = timeout;
            this.executor = executor;
            this.supplier = supplier;
            this.size = size;
            this.flush = () -> {
                if (this.terminated.get() == 0) {
                    int index;
                    do {
                        if ((index = this.index.get()) != 0) continue;
                        return;
                    } while (!this.index.compareAndSet(index, 0));
                    this.flushCallback();
                }
            };
        }

        private void doOnSubscribe() {
            this.current = this.supplier.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void nextCallback(T value) {
            MultiBufferWithTimeoutProcessor multiBufferWithTimeoutProcessor = this;
            synchronized (multiBufferWithTimeoutProcessor) {
                if (this.current == null) {
                    this.current = this.supplier.get();
                }
                this.current.add(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushCallback() {
            List cur;
            boolean flush = false;
            MultiBufferWithTimeoutProcessor multiBufferWithTimeoutProcessor = this;
            synchronized (multiBufferWithTimeoutProcessor) {
                cur = this.current != null ? new ArrayList<T>(this.current) : Collections.emptyList();
                if (!cur.isEmpty()) {
                    this.current = this.supplier.get();
                    flush = true;
                }
            }
            if (flush) {
                long req = this.requested.get();
                if (req != 0L) {
                    if (req != Long.MAX_VALUE) {
                        do {
                            long next;
                            if (!this.requested.compareAndSet(req, next = req - 1L)) continue;
                            this.downstream.onItem(cur);
                            return;
                        } while ((req = this.requested.get()) > 0L);
                    } else {
                        this.downstream.onItem(cur);
                        return;
                    }
                }
                this.cancel();
                this.downstream.onFailure(new BackPressureFailure("Cannot emit item due to lack of requests"));
            }
        }

        @Override
        public void onItem(T value) {
            int index;
            while (!this.index.compareAndSet((index = this.index.get() + 1) - 1, index)) {
            }
            if (index == 1) {
                try {
                    this.task = this.executor.schedule(this.flush, this.duration.toMillis(), TimeUnit.MILLISECONDS);
                }
                catch (RejectedExecutionException rejected) {
                    this.onFailure(rejected);
                    return;
                }
            }
            this.nextCallback(value);
            if (this.index.get() % this.size == 0) {
                this.index.lazySet(0);
                if (this.task != null) {
                    this.task.cancel(false);
                    this.task = null;
                }
                this.flushCallback();
            }
        }

        void checkedComplete() {
            try {
                this.flushCallback();
            }
            finally {
                super.onCompletion();
            }
        }

        final boolean isCompleted() {
            return this.terminated.get() == 1;
        }

        final boolean isFailed() {
            return this.terminated.get() == 2;
        }

        @Override
        public void request(long n) {
            if (n > 0L) {
                Subscriptions.add(this.requested, n);
                if (this.terminated.get() != 0) {
                    return;
                }
                if (this.size == Integer.MAX_VALUE || n == Long.MAX_VALUE) {
                    super.request(Long.MAX_VALUE);
                } else {
                    super.request(Subscriptions.multiply(n, this.size));
                }
            }
        }

        @Override
        public void onCompletion() {
            if (this.terminated.compareAndSet(0, 1)) {
                if (this.task != null) {
                    this.task.cancel(true);
                    this.task = null;
                }
                this.checkedComplete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(Throwable throwable) {
            if (this.terminated.compareAndSet(0, 2)) {
                MultiBufferWithTimeoutProcessor multiBufferWithTimeoutProcessor = this;
                synchronized (multiBufferWithTimeoutProcessor) {
                    if (this.current != null) {
                        this.current.clear();
                        this.current = null;
                    }
                }
                super.onFailure(throwable);
            }
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            if (this.upstream.compareAndSet(null, subscription)) {
                this.doOnSubscribe();
                this.downstream.onSubscribe(this);
            } else {
                subscription.cancel();
            }
        }

        @Override
        public void cancel() {
            if (this.terminated.compareAndSet(0, 3)) {
                super.cancel();
                List<T> cur = this.current;
                if (cur != null) {
                    cur.clear();
                }
            }
        }
    }
}

