/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.description;

import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.assertj.core.description.Description;
import org.assertj.core.util.Objects;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public class JoinDescription
extends Description {
    private static final int DEFAULT_INDENTATION = 3;
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String DELIMITER = ',' + LINE_SEPARATOR;
    @VisibleForTesting
    final Collection<Description> descriptions;
    @VisibleForTesting
    final String prefix;
    @VisibleForTesting
    final String suffix;

    public JoinDescription(String prefix, String suffix, Collection<Description> descriptions) {
        this.prefix = java.util.Objects.requireNonNull(prefix);
        this.suffix = java.util.Objects.requireNonNull(suffix);
        this.descriptions = java.util.Objects.requireNonNull(descriptions).stream().map(JoinDescription::checkNotNull).collect(Collectors.toList());
    }

    private static Description checkNotNull(Description description) {
        Preconditions.checkNotNull(description, "The descriptions should not contain null elements");
        return description;
    }

    @Override
    public String value() {
        IndentedAppendable indentableBuilder = new IndentedAppendable(new StringBuilder());
        return this.appendIndentedValueTo(indentableBuilder).toString();
    }

    public int hashCode() {
        return 31 + Objects.hashCodeFor(this.prefix) + Objects.hashCodeFor(this.suffix) + Objects.hashCodeFor(this.descriptions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JoinDescription)) {
            return false;
        }
        JoinDescription that = (JoinDescription)o;
        return Objects.areEqual(this.descriptions, that.descriptions) && Objects.areEqual(this.prefix, that.prefix) && Objects.areEqual(this.suffix, that.suffix);
    }

    private IndentedAppendable appendIndentedValueTo(IndentedAppendable indentableBuilder) {
        indentableBuilder.indent().append(this.prefix);
        if (this.descriptions.isEmpty()) {
            return indentableBuilder.append(this.suffix);
        }
        indentableBuilder.append(LINE_SEPARATOR);
        indentableBuilder.changeIndentationBy(3);
        Iterator<Description> it = this.descriptions.iterator();
        while (it.hasNext()) {
            Description description = it.next();
            if (description instanceof JoinDescription) {
                JoinDescription joinDescription = (JoinDescription)description;
                joinDescription.appendIndentedValueTo(indentableBuilder);
            } else {
                indentableBuilder.indent().append(description.value());
            }
            if (!it.hasNext()) continue;
            indentableBuilder.append(DELIMITER);
        }
        return indentableBuilder.append(LINE_SEPARATOR).indentBy(-3).append(this.suffix);
    }

    private static class IndentedAppendable
    implements Appendable {
        private final StringBuilder stringBuilder;
        private int currentIndentation;

        IndentedAppendable(StringBuilder stringBuilder) {
            this.stringBuilder = stringBuilder;
            this.currentIndentation = 0;
        }

        @Override
        public IndentedAppendable append(CharSequence charSequence) {
            this.stringBuilder.append(charSequence);
            return this;
        }

        @Override
        public IndentedAppendable append(CharSequence charSequence, int start, int end) {
            this.stringBuilder.append(charSequence, start, end);
            return this;
        }

        @Override
        public IndentedAppendable append(char c) {
            this.stringBuilder.append(c);
            return this;
        }

        IndentedAppendable changeIndentationBy(int indentation) {
            this.currentIndentation += indentation;
            return this;
        }

        IndentedAppendable indent() {
            for (int i = 0; i < this.currentIndentation; ++i) {
                this.stringBuilder.append(' ');
            }
            return this;
        }

        IndentedAppendable indentBy(int indentation) {
            return this.changeIndentationBy(indentation).indent();
        }

        public String toString() {
            return this.stringBuilder.toString();
        }
    }
}

