/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.lang.reflect.Array;
import java.util.Map;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.error.ShouldHaveLineCount;
import org.assertj.core.error.ShouldHaveSameSizeAs;
import org.assertj.core.error.ShouldHaveSize;
import org.assertj.core.error.ShouldHaveSizeBetween;
import org.assertj.core.error.ShouldHaveSizeGreaterThan;
import org.assertj.core.error.ShouldHaveSizeGreaterThanOrEqualTo;
import org.assertj.core.error.ShouldHaveSizeLessThan;
import org.assertj.core.error.ShouldHaveSizeLessThanOrEqualTo;
import org.assertj.core.internal.CommonErrors;
import org.assertj.core.internal.ErrorMessages;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.Preconditions;

public final class CommonValidations {
    private static Failures failures = Failures.instance();

    private CommonValidations() {
    }

    static void checkIndexValueIsValid(Index index, int maximum) {
        Preconditions.checkNotNull(index, "Index should not be null");
        if (index.value <= maximum) {
            return;
        }
        String errorMessage = "Index should be between <0> and <%d> (inclusive) but was:%n <%d>";
        throw new IndexOutOfBoundsException(String.format(errorMessage, maximum, index.value));
    }

    static void checkOffsetIsNotNull(Offset<?> offset) {
        Preconditions.checkNotNull(offset, "The given offset should not be null");
    }

    static void checkPercentageIsNotNull(Percentage percentage) {
        Preconditions.checkNotNull(percentage, "The given percentage should not be null");
    }

    static void checkNumberIsNotNull(Number number) {
        Preconditions.checkNotNull(number, "The given number should not be null");
    }

    static void checkIsNotEmpty(Object[] values) {
        if (values.length == 0) {
            throw CommonErrors.arrayOfValuesToLookForIsEmpty();
        }
    }

    static void checkIsNotEmpty(Iterable<?> iterable) {
        if (!iterable.iterator().hasNext()) {
            throw CommonErrors.iterableOfValuesToLookForIsEmpty();
        }
    }

    public static void checkIsNotNull(Object[] values) {
        if (values == null) {
            throw CommonErrors.arrayOfValuesToLookForIsNull();
        }
    }

    static void checkIsNotNull(Iterable<?> iterable) {
        if (iterable == null) {
            throw CommonErrors.iterableOfValuesToLookForIsNull();
        }
    }

    static void checkIsNotNullAndNotEmpty(Object[] values) {
        CommonValidations.checkIsNotNull(values);
        CommonValidations.checkIsNotEmpty(values);
    }

    static void checkIsNotNullAndNotEmpty(Iterable<?> iterable) {
        CommonValidations.checkIsNotNull(iterable);
        CommonValidations.checkIsNotEmpty(iterable);
    }

    public static void failIfEmptySinceActualIsNotEmpty(Object[] values) {
        if (values.length == 0) {
            throw new AssertionError((Object)"actual is not empty");
        }
    }

    public static void hasSameSizeAsCheck(AssertionInfo info, Object actual, Object other, int sizeOfActual) {
        CommonValidations.checkOtherIsNotNull(other, "Array");
        CommonValidations.checkSameSizes(info, actual, other, sizeOfActual, Array.getLength(other));
    }

    public static void hasSameSizeAsCheck(AssertionInfo info, Object actual, Iterable<?> other, int sizeOfActual) {
        CommonValidations.checkOtherIsNotNull(other, "Iterable");
        CommonValidations.checkSameSizes(info, actual, other, sizeOfActual, IterableUtil.sizeOf(other));
    }

    public static void hasSameSizeAsCheck(AssertionInfo info, Object actual, Map<?, ?> other, int sizeOfActual) {
        CommonValidations.checkOtherIsNotNull(other, "Map");
        CommonValidations.checkSameSizes(info, actual, other, sizeOfActual, other.size());
    }

    static void checkOtherIsNotNull(Object other, String otherType) {
        Preconditions.checkNotNull(other, "The " + otherType + " to compare actual size with should not be null");
    }

    static void checkSameSizes(AssertionInfo info, Object actual, Object other, int sizeOfActual, int sizeOfOther) {
        if (sizeOfActual != sizeOfOther) {
            throw failures.failure(info, ShouldHaveSameSizeAs.shouldHaveSameSizeAs(actual, other, sizeOfActual, sizeOfOther));
        }
    }

    public static void checkSizes(Object actual, int sizeOfActual, int sizeOfOther, AssertionInfo info) {
        if (sizeOfActual != sizeOfOther) {
            throw failures.failure(info, ShouldHaveSize.shouldHaveSize(actual, sizeOfActual, sizeOfOther));
        }
    }

    public static void checkSizeGreaterThan(Object actual, int boundary, int sizeOfActual, AssertionInfo info) {
        if (sizeOfActual <= boundary) {
            throw failures.failure(info, ShouldHaveSizeGreaterThan.shouldHaveSizeGreaterThan(actual, sizeOfActual, boundary));
        }
    }

    public static void checkSizeGreaterThanOrEqualTo(Object actual, int boundary, int sizeOfActual, AssertionInfo info) {
        if (sizeOfActual < boundary) {
            throw failures.failure(info, ShouldHaveSizeGreaterThanOrEqualTo.shouldHaveSizeGreaterThanOrEqualTo(actual, sizeOfActual, boundary));
        }
    }

    public static void checkSizeLessThan(Object actual, int boundary, int sizeOfActual, AssertionInfo info) {
        if (sizeOfActual >= boundary) {
            throw failures.failure(info, ShouldHaveSizeLessThan.shouldHaveSizeLessThan(actual, sizeOfActual, boundary));
        }
    }

    public static void checkSizeLessThanOrEqualTo(Object actual, int boundary, int sizeOfActual, AssertionInfo info) {
        if (sizeOfActual > boundary) {
            throw failures.failure(info, ShouldHaveSizeLessThanOrEqualTo.shouldHaveSizeLessThanOrEqualTo(actual, sizeOfActual, boundary));
        }
    }

    public static void checkSizeBetween(Object actual, int lowerBoundary, int higherBoundary, int sizeOfActual, AssertionInfo info) {
        if (higherBoundary < lowerBoundary) {
            throw new IllegalArgumentException(String.format("The higher boundary <%s> must be greater than the lower boundary <%s>.", higherBoundary, lowerBoundary));
        }
        if (lowerBoundary > sizeOfActual || sizeOfActual > higherBoundary) {
            throw failures.failure(info, ShouldHaveSizeBetween.shouldHaveSizeBetween(actual, sizeOfActual, lowerBoundary, higherBoundary));
        }
    }

    public static void checkLineCounts(Object actual, int lineCountOfActual, int lineCountOfOther, AssertionInfo info) {
        if (lineCountOfActual != lineCountOfOther) {
            throw failures.failure(info, ShouldHaveLineCount.shouldHaveLinesCount(actual, lineCountOfActual, lineCountOfOther));
        }
    }

    public static void checkTypeIsNotNull(Class<?> expectedType) {
        Preconditions.checkNotNull(expectedType, "The given type should not be null");
    }

    public static void checkIterableIsNotNull(Iterable<?> set) {
        if (set == null) {
            throw CommonValidations.iterableToLookForIsNull();
        }
    }

    public static NullPointerException iterableToLookForIsNull() {
        return new NullPointerException("The iterable to look for should not be null");
    }

    public static void checkSequenceIsNotNull(Object sequence) {
        if (sequence == null) {
            throw new NullPointerException(ErrorMessages.nullSequence());
        }
    }

    public static void checkSubsequenceIsNotNull(Object subsequence) {
        if (subsequence == null) {
            throw new NullPointerException(ErrorMessages.nullSubsequence());
        }
    }
}

