/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import java.util.function.Supplier;

public final class Expressions {
    private static final ThreadLocal<Boolean> ENABLE = ThreadLocal.withInitial(() -> Boolean.TRUE);

    private Expressions() {
        throw new UnsupportedOperationException();
    }

    public static boolean isEnabled() {
        return ENABLE.get();
    }

    public static void withoutExpansion(Runnable action) {
        Expressions.withoutExpansion(() -> {
            action.run();
            return null;
        });
    }

    public static <T> T withoutExpansion(Supplier<T> supplier) {
        if (Expressions.isEnabled()) {
            ENABLE.set(false);
            try {
                T t = supplier.get();
                return t;
            }
            finally {
                ENABLE.set(true);
            }
        }
        return supplier.get();
    }
}

