/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiOnTerminationInvoke;
import io.smallrye.mutiny.operators.multi.MultiOnTerminationInvokeUni;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class MultiOnTerminate<T> {
    private final Multi<T> upstream;

    public MultiOnTerminate(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Multi<T> invoke(BiConsumer<Throwable, Boolean> callback) {
        return Infrastructure.onMultiCreation(new MultiOnTerminationInvoke<T>(this.upstream, ParameterValidation.nonNull(callback, "callback")));
    }

    public Multi<T> invoke(Runnable action) {
        Runnable runnable = ParameterValidation.nonNull(action, "action");
        return Infrastructure.onMultiCreation(new MultiOnTerminationInvoke<T>(this.upstream, (f, c) -> runnable.run()));
    }

    public Multi<T> invokeUni(BiFunction<Throwable, Boolean, Uni<?>> mapper) {
        return Infrastructure.onMultiCreation(new MultiOnTerminationInvokeUni<T>(this.upstream, mapper));
    }
}

