/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.helpers.ParameterValidation;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class Subscriptions {
    public static final Throwable TERMINATED = new Exception("Terminated");
    public static final EmptySubscription CANCELLED = new EmptySubscription();

    private Subscriptions() {
    }

    public static IllegalArgumentException getInvalidRequestException() {
        return new IllegalArgumentException("Invalid request number, must be greater than 0");
    }

    public static Subscription empty() {
        return new EmptySubscription();
    }

    public static void complete(Subscriber<?> subscriber) {
        ParameterValidation.nonNull(subscriber, "subscriber");
        subscriber.onSubscribe(Subscriptions.empty());
        subscriber.onComplete();
    }

    public static void fail(Subscriber<?> subscriber, Throwable failure) {
        Subscriptions.fail(subscriber, failure, null);
    }

    public static void fail(Subscriber<?> subscriber, Throwable failure, Publisher<?> upstream) {
        ParameterValidation.nonNull(subscriber, "subscriber");
        ParameterValidation.nonNull(failure, "failure");
        if (upstream != null) {
            upstream.subscribe(new CancelledSubscriber());
        }
        subscriber.onSubscribe(Subscriptions.empty());
        subscriber.onError(failure);
    }

    public static long add(long a, long b) {
        long u = a + b;
        if (u < 0L) {
            return Long.MAX_VALUE;
        }
        return u;
    }

    public static long add(AtomicLong requested, long requests) {
        long u;
        long r;
        do {
            if ((r = requested.get()) != Long.MAX_VALUE) continue;
            return Long.MAX_VALUE;
        } while (!requested.compareAndSet(r, u = Subscriptions.add(r, requests)));
        return r;
    }

    public static long subtract(AtomicLong requested, long emitted) {
        long update;
        long current;
        do {
            if ((current = requested.get()) == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            update = current - emitted;
            if (update >= 0L) continue;
            update = 0L;
        } while (!requested.compareAndSet(current, update));
        return update;
    }

    public static int unboundedOrLimit(int prefetch) {
        return prefetch == Integer.MAX_VALUE ? Integer.MAX_VALUE : prefetch - (prefetch >> 2);
    }

    public static long unboundedOrMaxConcurrency(int concurrency) {
        return concurrency == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)concurrency;
    }

    public static boolean addFailure(AtomicReference<Throwable> failures, Throwable failure) {
        Throwable current = failures.get();
        if (current == TERMINATED) {
            return false;
        }
        if (current instanceof CompositeException) {
            failures.set(new CompositeException((CompositeException)current, failure));
            return true;
        }
        if (current == null) {
            failures.set(failure);
        } else {
            failures.set(new CompositeException(current, failure));
        }
        return true;
    }

    public static void cancel(AtomicReference<Subscription> reference) {
        Subscription actual = reference.getAndSet(CANCELLED);
        if (actual != null && actual != CANCELLED) {
            actual.cancel();
        }
    }

    public static Throwable markFailureAsTerminated(AtomicReference<Throwable> failures) {
        return failures.getAndSet(TERMINATED);
    }

    public static void terminateAndPropagate(AtomicReference<Throwable> failures, Subscriber<?> subscriber) {
        Throwable ex = Subscriptions.markFailureAsTerminated(failures);
        if (ex == null) {
            subscriber.onComplete();
        } else if (ex != TERMINATED) {
            subscriber.onError(ex);
        }
    }

    public static long multiply(long n, long times) {
        long u = n * times;
        if ((n | times) >>> 31 != 0L && u / n != times) {
            return Long.MAX_VALUE;
        }
        return u;
    }

    public static void requestIfNotNullOrAccumulate(AtomicReference<Subscription> field, AtomicLong requested, long requests) {
        Subscription subscription = field.get();
        if (subscription != null) {
            subscription.request(requests);
        } else if (requests > 0L) {
            long r;
            Subscriptions.add(requested, requests);
            subscription = field.get();
            if (subscription != null && (r = requested.getAndSet(0L)) != 0L) {
                subscription.request(r);
            }
        }
    }

    public static boolean setIfEmptyAndRequest(AtomicReference<Subscription> container, AtomicLong requested, Subscription subscription) {
        if (Subscriptions.setIfEmpty(container, subscription)) {
            long r = requested.getAndSet(0L);
            if (r > 0L) {
                subscription.request(r);
            } else if (r < 0L) {
                throw new IllegalArgumentException("Invalid amount of request");
            }
            return true;
        }
        return false;
    }

    public static boolean setIfEmpty(AtomicReference<Subscription> container, Subscription subscription) {
        Objects.requireNonNull(subscription, "subscription is null");
        if (!container.compareAndSet(null, subscription)) {
            subscription.cancel();
            return false;
        }
        return true;
    }

    public static Throwable terminate(AtomicReference<Throwable> failure) {
        return failure.getAndSet(TERMINATED);
    }

    public static long produced(AtomicLong requested, long amount) {
        long u;
        long r;
        do {
            if ((r = requested.get()) != 0L && r != Long.MAX_VALUE) continue;
            return r;
        } while (!requested.compareAndSet(r, u = Subscriptions.subOrZero(r, amount)));
        return u;
    }

    public static long subOrZero(long a, long b) {
        long res = a - b;
        if (res < 0L) {
            return 0L;
        }
        return res;
    }

    public static <T> SingleItemSubscription<T> single(Subscriber<T> downstream, T item) {
        return new SingleItemSubscription<T>(downstream, item);
    }

    public static long producedAndHandleAlreadyCancelled(AtomicLong requested, long n) {
        long update;
        long current;
        do {
            if ((current = requested.get()) == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            if (current == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            update = current - n;
            if (update >= 0L) continue;
            update = 0L;
        } while (!requested.compareAndSet(current, update));
        return update;
    }

    public static long addAndHandledAlreadyCancelled(AtomicLong requested, long n) {
        long u;
        long r;
        do {
            if ((r = requested.get()) == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            if (r != Long.MAX_VALUE) continue;
            return Long.MAX_VALUE;
        } while (!requested.compareAndSet(r, u = Subscriptions.add(r, n)));
        return r;
    }

    public static class DeferredSubscription
    implements Subscription {
        private AtomicReference<Subscription> subscription = new AtomicReference();
        private AtomicLong pendingRequests = new AtomicLong();

        protected boolean isCancelled() {
            return this.subscription.get() == CANCELLED;
        }

        @Override
        public void cancel() {
            Subscription actual = this.subscription.get();
            if (actual != CANCELLED && (actual = this.subscription.getAndSet(CANCELLED)) != null && actual != CANCELLED) {
                actual.cancel();
            }
        }

        @Override
        public void request(long n) {
            Subscription actual = this.subscription.get();
            if (actual != null) {
                actual.request(n);
            } else {
                long r;
                Subscriptions.add(this.pendingRequests, n);
                actual = this.subscription.get();
                if (actual != null && (r = this.pendingRequests.getAndSet(0L)) != 0L) {
                    actual.request(r);
                }
            }
        }

        public boolean set(Subscription newSubscription) {
            ParameterValidation.nonNull(newSubscription, "newSubscription");
            Subscription actual = this.subscription.get();
            if (actual == CANCELLED) {
                newSubscription.cancel();
                return false;
            }
            if (actual != null) {
                newSubscription.cancel();
                return false;
            }
            if (this.subscription.compareAndSet(null, newSubscription)) {
                long r = this.pendingRequests.getAndSet(0L);
                if (r != 0L) {
                    newSubscription.request(r);
                }
                return true;
            }
            actual = this.subscription.get();
            if (actual != CANCELLED) {
                newSubscription.cancel();
                return false;
            }
            return false;
        }
    }

    public static class CancelledSubscriber<X>
    implements Subscriber<X> {
        @Override
        public void onSubscribe(Subscription s) {
            Objects.requireNonNull(s).cancel();
        }

        @Override
        public void onNext(X o) {
        }

        @Override
        public void onError(Throwable t) {
        }

        @Override
        public void onComplete() {
        }
    }

    private static final class SingleItemSubscription<T>
    implements Subscription {
        private final Subscriber<? super T> downstream;
        private final T item;
        private AtomicBoolean requested = new AtomicBoolean();

        public SingleItemSubscription(Subscriber<? super T> actual, T item) {
            this.downstream = ParameterValidation.nonNull(actual, "actual");
            this.item = ParameterValidation.nonNull(item, "item");
        }

        @Override
        public void cancel() {
            this.requested.lazySet(true);
        }

        @Override
        public void request(long requests) {
            if (requests > 0L && this.requested.compareAndSet(false, true)) {
                this.downstream.onNext(this.item);
                this.downstream.onComplete();
            }
        }
    }

    public static class EmptySubscription
    implements Subscription {
        @Override
        public void request(long requests) {
            ParameterValidation.positive(requests, "requests");
        }

        @Override
        public void cancel() {
        }
    }
}

