/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniDelegatingSubscriber;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.UniSerializedSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

public class UniOnSubscribeInvokeUni<T>
extends UniOperator<T, T> {
    private final Function<? super UniSubscription, Uni<?>> callback;

    public UniOnSubscribeInvokeUni(Uni<? extends T> upstream, Function<? super UniSubscription, Uni<?>> callback) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.callback = callback;
    }

    @Override
    protected void subscribing(UniSerializedSubscriber<? super T> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniDelegatingSubscriber<T, T>(subscriber){
            volatile T item;
            volatile Throwable failure;
            final AtomicBoolean done;
            {
                this.done = new AtomicBoolean();
            }

            @Override
            public void onSubscribe(UniSubscription subscription) {
                Uni uni;
                try {
                    uni = (Uni)Objects.requireNonNull(UniOnSubscribeInvokeUni.this.callback.apply(subscription), "The produced Uni must not be `null`");
                }
                catch (Throwable e) {
                    super.onSubscribe(EmptyUniSubscription.CANCELLED);
                    super.onFailure(e);
                    return;
                }
                uni.subscribe().with(ignored -> {
                    super.onSubscribe(subscription);
                    if (this.done.compareAndSet(false, true)) {
                        this.forwardPendingEvent();
                    }
                }, failed -> {
                    super.onSubscribe(EmptyUniSubscription.CANCELLED);
                    super.onFailure((Throwable)failed);
                });
            }

            private void forwardPendingEvent() {
                if (this.item != null) {
                    super.onItem(this.item);
                } else if (this.failure != null) {
                    super.onFailure(this.failure);
                }
            }

            @Override
            public void onItem(T item) {
                if (this.done.get()) {
                    super.onItem(item);
                } else {
                    this.item = item;
                }
            }

            @Override
            public void onFailure(Throwable failure) {
                if (this.done.get()) {
                    super.onFailure(failure);
                } else {
                    this.failure = failure;
                }
            }
        });
    }
}

