/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.inject.ConfigInjectionBean;
import io.smallrye.config.inject.ConfigProducer;
import io.smallrye.config.inject.InjectionMessages;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.inject.Provider;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ConfigExtension
implements Extension {
    private Set<InjectionPoint> injectionPoints = new HashSet<InjectionPoint>();

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd, BeanManager bm) {
        AnnotatedType<ConfigProducer> configBean = bm.createAnnotatedType(ConfigProducer.class);
        bbd.addAnnotatedType(configBean, ConfigProducer.class.getName());
    }

    void collectConfigPropertyInjectionPoints(@Observes ProcessInjectionPoint<?, ?> pip) {
        if (pip.getInjectionPoint().getAnnotated().isAnnotationPresent(ConfigProperty.class)) {
            this.injectionPoints.add(pip.getInjectionPoint());
        }
    }

    void registerCustomBeans(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        HashSet<Class> customTypes = new HashSet<Class>();
        for (InjectionPoint ip : this.injectionPoints) {
            Type requiredType = ip.getType();
            if (requiredType instanceof ParameterizedType) {
                Type typeArgument;
                ParameterizedType type = (ParameterizedType)requiredType;
                if (!type.getRawType().equals(Provider.class) && !type.getRawType().equals(Instance.class) || !((typeArgument = type.getActualTypeArguments()[0]) instanceof Class) || ConfigExtension.isClassHandledByConfigProducer(typeArgument)) continue;
                customTypes.add((Class)typeArgument);
                continue;
            }
            if (!(requiredType instanceof Class) || ConfigExtension.isClassHandledByConfigProducer(requiredType)) continue;
            customTypes.add((Class)requiredType);
        }
        for (Class customType : customTypes) {
            abd.addBean(new ConfigInjectionBean(bm, customType));
        }
    }

    void validate(@Observes AfterDeploymentValidation adv) {
        Config config = ConfigProvider.getConfig();
        for (InjectionPoint injectionPoint : this.injectionPoints) {
            Class rawType;
            Type type = injectionPoint.getType();
            ConfigProperty configProperty = injectionPoint.getAnnotated().getAnnotation(ConfigProperty.class);
            if (type instanceof Class) {
                String key = ConfigExtension.getConfigKey(injectionPoint, configProperty);
                try {
                    String defaultValue;
                    if (config.getOptionalValue(key, (Class)type).isPresent() || (defaultValue = configProperty.defaultValue()) != null && !defaultValue.equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) continue;
                    adv.addDeploymentProblem(InjectionMessages.msg.noConfigValue(key));
                }
                catch (IllegalArgumentException cause) {
                    adv.addDeploymentProblem(InjectionMessages.msg.retrieveConfigFailure(cause, key));
                }
                continue;
            }
            if (!(type instanceof ParameterizedType) || !Collection.class.isAssignableFrom(rawType = (Class)((ParameterizedType)type).getRawType())) continue;
            String key = ConfigExtension.getConfigKey(injectionPoint, configProperty);
            try {
                String defaultValue;
                if (config.getOptionalValue(key, String.class).isPresent() || (defaultValue = configProperty.defaultValue()) != null && !defaultValue.equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) continue;
                adv.addDeploymentProblem(InjectionMessages.msg.noConfigValue(key));
            }
            catch (IllegalArgumentException cause) {
                adv.addDeploymentProblem(InjectionMessages.msg.retrieveConfigFailure(cause, key));
            }
        }
    }

    static String getConfigKey(InjectionPoint ip, ConfigProperty configProperty) {
        AnnotatedMember member;
        AnnotatedType declaringType;
        String key = configProperty.name();
        if (!key.trim().isEmpty()) {
            return key;
        }
        if (ip.getAnnotated() instanceof AnnotatedMember && (declaringType = (member = (AnnotatedMember)ip.getAnnotated()).getDeclaringType()) != null) {
            String[] parts = declaringType.getJavaClass().getCanonicalName().split("\\.");
            StringBuilder sb = new StringBuilder(parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                sb.append(".").append(parts[i]);
            }
            sb.append(".").append(member.getJavaMember().getName());
            return sb.toString();
        }
        throw InjectionMessages.msg.noConfigPropertyDefaultName(ip);
    }

    private static boolean isClassHandledByConfigProducer(Type requiredType) {
        return requiredType == String.class || requiredType == Boolean.class || requiredType == Boolean.TYPE || requiredType == Integer.class || requiredType == Integer.TYPE || requiredType == Long.class || requiredType == Long.TYPE || requiredType == Float.class || requiredType == Float.TYPE || requiredType == Double.class || requiredType == Double.TYPE || requiredType == Short.class || requiredType == Short.TYPE || requiredType == Byte.class || requiredType == Byte.TYPE || requiredType == Character.class || requiredType == Character.TYPE || requiredType == OptionalInt.class || requiredType == OptionalLong.class || requiredType == OptionalDouble.class;
    }
}

