/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.logging;

import io.quarkus.bootstrap.logging.InitialConfigurator;
import io.quarkus.dev.console.CurrentAppExceptionHighlighter;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigInstantiator;
import io.quarkus.runtime.console.ConsoleRuntimeConfig;
import io.quarkus.runtime.logging.AsyncConfig;
import io.quarkus.runtime.logging.BannerFormatter;
import io.quarkus.runtime.logging.CategoryBuildTimeConfig;
import io.quarkus.runtime.logging.CategoryConfig;
import io.quarkus.runtime.logging.CleanupFilterConfig;
import io.quarkus.runtime.logging.ConsoleConfig;
import io.quarkus.runtime.logging.FileConfig;
import io.quarkus.runtime.logging.InheritableLevel;
import io.quarkus.runtime.logging.LogBuildTimeConfig;
import io.quarkus.runtime.logging.LogCleanupFilter;
import io.quarkus.runtime.logging.LogCleanupFilterElement;
import io.quarkus.runtime.logging.LogConfig;
import io.quarkus.runtime.logging.SyslogConfig;
import io.quarkus.runtime.util.ColorSupport;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.graalvm.nativeimage.ImageInfo;
import org.jboss.logmanager.EmbeddedConfigurator;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.errormanager.OnlyOnceErrorManager;
import org.jboss.logmanager.formatters.ColorPatternFormatter;
import org.jboss.logmanager.formatters.PatternFormatter;
import org.jboss.logmanager.handlers.AsyncHandler;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.logmanager.handlers.FileHandler;
import org.jboss.logmanager.handlers.PeriodicRotatingFileHandler;
import org.jboss.logmanager.handlers.PeriodicSizeRotatingFileHandler;
import org.jboss.logmanager.handlers.SizeRotatingFileHandler;
import org.jboss.logmanager.handlers.SyslogHandler;
import org.wildfly.common.net.HostName;
import org.wildfly.common.os.Process;

@Recorder
public class LoggingSetupRecorder {
    private static final org.jboss.logging.Logger log = org.jboss.logging.Logger.getLogger(LoggingSetupRecorder.class);

    public static void handleFailedStart() {
        LoggingSetupRecorder.handleFailedStart(new RuntimeValue<Optional<Supplier<String>>>(Optional.empty()));
    }

    public static void handleFailedStart(RuntimeValue<Optional<Supplier<String>>> banner) {
        LogConfig config = new LogConfig();
        ConfigInstantiator.handleObject(config);
        LogBuildTimeConfig buildConfig = new LogBuildTimeConfig();
        ConfigInstantiator.handleObject(buildConfig);
        ConsoleRuntimeConfig consoleRuntimeConfig = new ConsoleRuntimeConfig();
        ConfigInstantiator.handleObject(consoleRuntimeConfig);
        new LoggingSetupRecorder().initializeLogging(config, buildConfig, consoleRuntimeConfig, false, null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), banner, LaunchMode.DEVELOPMENT);
    }

    public void initializeLogging(LogConfig config, final LogBuildTimeConfig buildConfig, ConsoleRuntimeConfig consoleConfig, boolean enableWebStream, RuntimeValue<Optional<Handler>> devUiConsoleHandler, List<RuntimeValue<Optional<Handler>>> additionalHandlers, List<RuntimeValue<Map<String, Handler>>> additionalNamedHandlers, List<RuntimeValue<Optional<Formatter>>> possibleFormatters, RuntimeValue<Optional<Supplier<String>>> possibleBannerSupplier, LaunchMode launchMode) {
        Handler syslogHandler;
        List<LogCleanupFilterElement> filterElements;
        final Map<String, CategoryConfig> categories = config.categories;
        LogContext logContext = LogContext.getLogContext();
        Logger rootLogger = logContext.getLogger("");
        if (config.level.intValue() < buildConfig.minLevel.intValue()) {
            log.warnf("Root log level %s set below minimum logging level %s, promoting it to %s", (Object)config.level, (Object)buildConfig.minLevel, (Object)buildConfig.minLevel);
            rootLogger.setLevel(buildConfig.minLevel);
        } else {
            rootLogger.setLevel(config.level);
        }
        ErrorManager errorManager = new OnlyOnceErrorManager();
        Map<String, CleanupFilterConfig> filters = config.filters;
        if (filters.isEmpty()) {
            filterElements = Collections.emptyList();
        } else {
            filterElements = new ArrayList(filters.size());
            filters.forEach(new BiConsumer<String, CleanupFilterConfig>(){

                @Override
                public void accept(String loggerName, CleanupFilterConfig config) {
                    filterElements.add(new LogCleanupFilterElement(loggerName, config.targetLevel, config.ifStartsWith));
                }
            });
        }
        LogCleanupFilter cleanupFiler = new LogCleanupFilter(filterElements);
        for (Handler handler : LogManager.getLogManager().getLogger("").getHandlers()) {
            handler.setFilter(cleanupFiler);
        }
        ArrayList<Handler> handlers = new ArrayList<Handler>(3 + additionalHandlers.size());
        if (config.console.enable) {
            Handler consoleHandler = LoggingSetupRecorder.configureConsoleHandler(config.console, consoleConfig, errorManager, cleanupFiler, possibleFormatters, possibleBannerSupplier, launchMode);
            errorManager = consoleHandler.getErrorManager();
            handlers.add(consoleHandler);
        }
        if (config.file.enable) {
            handlers.add(LoggingSetupRecorder.configureFileHandler(config.file, errorManager, cleanupFiler));
        }
        if (config.syslog.enable && (syslogHandler = LoggingSetupRecorder.configureSyslogHandler(config.syslog, errorManager, cleanupFiler)) != null) {
            handlers.add(syslogHandler);
        }
        if ((launchMode.isDevOrTest() || enableWebStream) && devUiConsoleHandler != null && devUiConsoleHandler.getValue().isPresent()) {
            Handler handler = devUiConsoleHandler.getValue().get();
            handler.setErrorManager(errorManager);
            handler.setFilter(new LogCleanupFilter(filterElements));
            if (possibleBannerSupplier != null && possibleBannerSupplier.getValue().isPresent()) {
                Supplier<String> bannerSupplier = possibleBannerSupplier.getValue().get();
                String header = "\n" + bannerSupplier.get();
                handler.publish(new LogRecord(Level.INFO, header));
            }
            handlers.add(handler);
        }
        if (!categories.isEmpty()) {
            Map<String, Handler> additionalNamedHandlersMap;
            Map<String, Handler> namedHandlers = LoggingSetupRecorder.createNamedHandlers(config, consoleConfig, possibleFormatters, errorManager, cleanupFiler, launchMode);
            if (additionalNamedHandlers.isEmpty()) {
                additionalNamedHandlersMap = Collections.emptyMap();
            } else {
                additionalNamedHandlersMap = new HashMap();
                for (RuntimeValue<Map<String, Handler>> runtimeValue : additionalNamedHandlers) {
                    runtimeValue.getValue().forEach(new AdditionalNamedHandlersConsumer(additionalNamedHandlersMap, errorManager, filterElements));
                }
            }
            namedHandlers.putAll(additionalNamedHandlersMap);
            categories.forEach(new BiConsumer<String, CategoryConfig>(){

                @Override
                public void accept(String categoryName, CategoryConfig config) {
                    Level minLogLevel;
                    CategoryBuildTimeConfig buildCategory = LoggingSetupRecorder.isSubsetOf(categoryName, buildConfig.categories);
                    Level logLevel = LoggingSetupRecorder.getLogLevel(categoryName, config, categories, buildConfig.minLevel);
                    Level level = minLogLevel = buildCategory == null ? buildConfig.minLevel : buildCategory.minLevel.getLevel();
                    if (logLevel.intValue() < minLogLevel.intValue()) {
                        log.warnf("Log level %s for category '%s' set below minimum logging level %s, promoting it to %s", logLevel, categoryName, minLogLevel, minLogLevel);
                        config.level = InheritableLevel.of(minLogLevel.toString());
                    }
                }
            });
            categories.forEach(new CategoryLoggerConsumer(logContext, namedHandlers, errorManager));
        }
        for (RuntimeValue<Optional<Handler>> additionalHandler : additionalHandlers) {
            Optional<Handler> optional = additionalHandler.getValue();
            if (!optional.isPresent()) continue;
            Handler handler = optional.get();
            handler.setErrorManager(errorManager);
            handler.setFilter(cleanupFiler);
            handlers.add(handler);
        }
        InitialConfigurator.DELAYED_HANDLER.setAutoFlush(false);
        InitialConfigurator.DELAYED_HANDLER.setHandlers(handlers.toArray(EmbeddedConfigurator.NO_HANDLERS));
    }

    public static void initializeBuildTimeLogging(LogConfig config, LogBuildTimeConfig buildConfig, ConsoleRuntimeConfig consoleConfig, LaunchMode launchMode) {
        Map<String, CategoryConfig> categories = config.categories;
        LogContext logContext = LogContext.getLogContext();
        Logger rootLogger = logContext.getLogger("");
        rootLogger.setLevel(config.level);
        ErrorManager errorManager = new OnlyOnceErrorManager();
        Map<String, CleanupFilterConfig> filters = config.filters;
        ArrayList<LogCleanupFilterElement> filterElements = new ArrayList<LogCleanupFilterElement>(filters.size());
        for (Map.Entry<String, CleanupFilterConfig> entry : filters.entrySet()) {
            filterElements.add(new LogCleanupFilterElement(entry.getKey(), entry.getValue().targetLevel, entry.getValue().ifStartsWith));
        }
        LogCleanupFilter logCleanupFilter = new LogCleanupFilter(filterElements);
        ArrayList<Handler> handlers = new ArrayList<Handler>(3);
        if (config.console.enable) {
            Handler consoleHandler = LoggingSetupRecorder.configureConsoleHandler(config.console, consoleConfig, errorManager, logCleanupFilter, Collections.emptyList(), new RuntimeValue<Optional<Supplier<String>>>(Optional.empty()), launchMode);
            errorManager = consoleHandler.getErrorManager();
            handlers.add(consoleHandler);
        }
        Map<String, Handler> namedHandlers = LoggingSetupRecorder.createNamedHandlers(config, consoleConfig, Collections.emptyList(), errorManager, logCleanupFilter, launchMode);
        for (Map.Entry<String, CategoryConfig> entry : categories.entrySet()) {
            Level minLogLevel;
            CategoryBuildTimeConfig buildCategory = LoggingSetupRecorder.isSubsetOf(entry.getKey(), buildConfig.categories);
            Level logLevel = LoggingSetupRecorder.getLogLevel(entry.getKey(), entry.getValue(), categories, buildConfig.minLevel);
            Level level = minLogLevel = buildCategory == null ? buildConfig.minLevel : buildCategory.minLevel.getLevel();
            if (logLevel.intValue() >= minLogLevel.intValue()) continue;
            log.warnf("Log level %s for category '%s' set below minimum logging level %s, promoting it to %s", logLevel, entry.getKey(), minLogLevel, minLogLevel);
            entry.getValue().level = InheritableLevel.of(minLogLevel.toString());
        }
        for (Map.Entry<String, CategoryConfig> entry : categories.entrySet()) {
            String name = entry.getKey();
            Logger categoryLogger = logContext.getLogger(name);
            CategoryConfig categoryConfig = entry.getValue();
            if (!categoryConfig.level.isInherited()) {
                categoryLogger.setLevel(categoryConfig.level.getLevel());
            }
            categoryLogger.setUseParentHandlers(categoryConfig.useParentHandlers);
            if (!categoryConfig.handlers.isPresent()) continue;
            LoggingSetupRecorder.addNamedHandlersToCategory(categoryConfig, namedHandlers, categoryLogger, errorManager);
        }
        InitialConfigurator.DELAYED_HANDLER.setAutoFlush(false);
        InitialConfigurator.DELAYED_HANDLER.setBuildTimeHandlers(handlers.toArray(EmbeddedConfigurator.NO_HANDLERS));
    }

    private static Level getLogLevel(String categoryName, CategoryConfig categoryConfig, Map<String, CategoryConfig> categories, Level rootMinLevel) {
        if (Objects.isNull(categoryConfig)) {
            return rootMinLevel;
        }
        InheritableLevel inheritableLevel = categoryConfig.level;
        if (!inheritableLevel.isInherited()) {
            return inheritableLevel.getLevel();
        }
        int lastDotIndex = categoryName.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return rootMinLevel;
        }
        String parent = categoryName.substring(0, lastDotIndex);
        return LoggingSetupRecorder.getLogLevel(parent, categories.get(parent), categories, rootMinLevel);
    }

    private static CategoryBuildTimeConfig isSubsetOf(String categoryName, Map<String, CategoryBuildTimeConfig> categories) {
        return categories.entrySet().stream().filter(buildCategoryEntry -> categoryName.startsWith((String)buildCategoryEntry.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    private static Map<String, Handler> createNamedHandlers(LogConfig config, ConsoleRuntimeConfig consoleRuntimeConfig, List<RuntimeValue<Optional<Formatter>>> possibleFormatters, ErrorManager errorManager, LogCleanupFilter cleanupFilter, LaunchMode launchMode) {
        HashMap<String, Handler> namedHandlers = new HashMap<String, Handler>();
        for (Map.Entry<String, ConsoleConfig> entry : config.consoleHandlers.entrySet()) {
            ConsoleConfig namedConsoleConfig = entry.getValue();
            if (!namedConsoleConfig.enable) continue;
            Handler consoleHandler = LoggingSetupRecorder.configureConsoleHandler(namedConsoleConfig, consoleRuntimeConfig, errorManager, cleanupFilter, possibleFormatters, null, launchMode);
            LoggingSetupRecorder.addToNamedHandlers(namedHandlers, consoleHandler, entry.getKey());
        }
        for (Map.Entry<String, Object> entry : config.fileHandlers.entrySet()) {
            FileConfig namedFileConfig = (FileConfig)entry.getValue();
            if (!namedFileConfig.enable) continue;
            Handler fileHandler = LoggingSetupRecorder.configureFileHandler(namedFileConfig, errorManager, cleanupFilter);
            LoggingSetupRecorder.addToNamedHandlers(namedHandlers, fileHandler, entry.getKey());
        }
        for (Map.Entry<String, Object> entry : config.syslogHandlers.entrySet()) {
            Handler syslogHandler;
            SyslogConfig namedSyslogConfig = (SyslogConfig)entry.getValue();
            if (!namedSyslogConfig.enable || (syslogHandler = LoggingSetupRecorder.configureSyslogHandler(namedSyslogConfig, errorManager, cleanupFilter)) == null) continue;
            LoggingSetupRecorder.addToNamedHandlers(namedHandlers, syslogHandler, entry.getKey());
        }
        return namedHandlers;
    }

    private static void addToNamedHandlers(Map<String, Handler> namedHandlers, final Handler handler, String handlerName) {
        if (namedHandlers.containsKey(handlerName)) {
            throw new RuntimeException(String.format("Only one handler can be configured with the same name '%s'", handlerName));
        }
        namedHandlers.put(handlerName, handler);
        InitialConfigurator.DELAYED_HANDLER.addLoggingCloseTask(new Runnable(){

            @Override
            public void run() {
                handler.close();
            }
        });
    }

    private static void addNamedHandlersToCategory(CategoryConfig categoryConfig, Map<String, Handler> namedHandlers, final Logger categoryLogger, ErrorManager errorManager) {
        for (String categoryNamedHandler : categoryConfig.handlers.get()) {
            final Handler handler = namedHandlers.get(categoryNamedHandler);
            if (handler != null) {
                categoryLogger.addHandler(handler);
                InitialConfigurator.DELAYED_HANDLER.addLoggingCloseTask(new Runnable(){

                    @Override
                    public void run() {
                        categoryLogger.removeHandler(handler);
                    }
                });
                continue;
            }
            errorManager.error(String.format("Handler with name '%s' is linked to a category but not configured.", categoryNamedHandler), null, 0);
        }
    }

    public void initializeLoggingForImageBuild() {
        if (ImageInfo.inImageBuildtimeCode()) {
            ConsoleHandler handler = new ConsoleHandler(new PatternFormatter("%d{HH:mm:ss,SSS} %-5p [%c{1.}] %s%e%n"));
            handler.setLevel(Level.INFO);
            InitialConfigurator.DELAYED_HANDLER.setAutoFlush(false);
            InitialConfigurator.DELAYED_HANDLER.setHandlers(new Handler[]{handler});
        }
    }

    private static Handler configureConsoleHandler(ConsoleConfig config, ConsoleRuntimeConfig consoleRuntimeConfig, ErrorManager defaultErrorManager, LogCleanupFilter cleanupFilter, List<RuntimeValue<Optional<Formatter>>> possibleFormatters, RuntimeValue<Optional<Supplier<String>>> possibleBannerSupplier, LaunchMode launchMode) {
        Handler handler;
        Formatter formatter = null;
        boolean formatterWarning = false;
        for (RuntimeValue<Optional<Formatter>> value : possibleFormatters) {
            Optional<Formatter> val;
            if (formatter != null) {
                formatterWarning = true;
            }
            if (!(val = value.getValue()).isPresent()) continue;
            formatter = val.get();
        }
        boolean color = false;
        if (formatter == null) {
            Supplier<String> bannerSupplier = null;
            if (possibleBannerSupplier != null && possibleBannerSupplier.getValue().isPresent()) {
                bannerSupplier = possibleBannerSupplier.getValue().get();
            }
            if (ColorSupport.isColorEnabled(consoleRuntimeConfig, config)) {
                color = true;
                ColorPatternFormatter colorPatternFormatter = new ColorPatternFormatter(config.darken, config.format);
                formatter = bannerSupplier != null ? new BannerFormatter(colorPatternFormatter, true, bannerSupplier) : colorPatternFormatter;
            } else {
                PatternFormatter patternFormatter = new PatternFormatter(config.format);
                formatter = bannerSupplier != null ? new BannerFormatter(patternFormatter, false, bannerSupplier) : patternFormatter;
            }
        }
        ConsoleHandler consoleHandler = new ConsoleHandler(config.stderr ? ConsoleHandler.Target.SYSTEM_ERR : ConsoleHandler.Target.SYSTEM_OUT, formatter);
        consoleHandler.setLevel(config.level);
        consoleHandler.setErrorManager(defaultErrorManager);
        consoleHandler.setFilter(cleanupFilter);
        ExtHandler extHandler = handler = config.async.enable ? LoggingSetupRecorder.createAsyncHandler(config.async, config.level, consoleHandler) : consoleHandler;
        if (color && launchMode.isDevOrTest() && !config.async.enable) {
            final ConsoleHandler delegate = handler;
            handler = new Handler(){

                @Override
                public void publish(LogRecord record) {
                    BiConsumer<LogRecord, Consumer<LogRecord>> formatter = CurrentAppExceptionHighlighter.THROWABLE_FORMATTER;
                    if (formatter != null) {
                        formatter.accept(record, delegate::publish);
                    } else {
                        delegate.publish(record);
                    }
                }

                @Override
                public void flush() {
                    delegate.flush();
                }

                @Override
                public void close() throws SecurityException {
                    delegate.close();
                }
            };
        }
        if (formatterWarning) {
            handler.getErrorManager().error("Multiple formatters were activated", null, 0);
        }
        return handler;
    }

    private static Handler configureFileHandler(FileConfig config, ErrorManager errorManager, LogCleanupFilter cleanupFilter) {
        FileHandler handler = new FileHandler();
        FileConfig.RotationConfig rotationConfig = config.rotation;
        if ((rotationConfig.maxFileSize.isPresent() || rotationConfig.rotateOnBoot) && rotationConfig.fileSuffix.isPresent()) {
            PeriodicSizeRotatingFileHandler periodicSizeRotatingFileHandler = new PeriodicSizeRotatingFileHandler();
            periodicSizeRotatingFileHandler.setSuffix(rotationConfig.fileSuffix.get());
            rotationConfig.maxFileSize.ifPresent(memorySize -> periodicSizeRotatingFileHandler.setRotateSize(memorySize.asLongValue()));
            periodicSizeRotatingFileHandler.setRotateOnBoot(rotationConfig.rotateOnBoot);
            periodicSizeRotatingFileHandler.setMaxBackupIndex(rotationConfig.maxBackupIndex);
            handler = periodicSizeRotatingFileHandler;
        } else if (rotationConfig.maxFileSize.isPresent()) {
            SizeRotatingFileHandler sizeRotatingFileHandler = new SizeRotatingFileHandler(rotationConfig.maxFileSize.get().asLongValue(), rotationConfig.maxBackupIndex);
            sizeRotatingFileHandler.setRotateOnBoot(rotationConfig.rotateOnBoot);
            handler = sizeRotatingFileHandler;
        } else if (rotationConfig.fileSuffix.isPresent()) {
            PeriodicRotatingFileHandler periodicRotatingFileHandler = new PeriodicRotatingFileHandler();
            periodicRotatingFileHandler.setSuffix(rotationConfig.fileSuffix.get());
            handler = periodicRotatingFileHandler;
        }
        PatternFormatter formatter = new PatternFormatter(config.format);
        handler.setFormatter(formatter);
        handler.setAppend(true);
        try {
            handler.setFile(config.path);
        }
        catch (FileNotFoundException e) {
            errorManager.error("Failed to set log file", e, 4);
        }
        handler.setErrorManager(errorManager);
        handler.setLevel(config.level);
        handler.setFilter(cleanupFilter);
        if (config.async.enable) {
            return LoggingSetupRecorder.createAsyncHandler(config.async, config.level, handler);
        }
        return handler;
    }

    private static Handler configureSyslogHandler(SyslogConfig config, ErrorManager errorManager, LogCleanupFilter logCleanupFilter) {
        try {
            SyslogHandler handler = new SyslogHandler(config.endpoint.getHostString(), config.endpoint.getPort());
            handler.setAppName(config.appName.orElse(Process.getProcessName()));
            handler.setHostname(config.hostname.orElse(HostName.getQualifiedHostName()));
            handler.setFacility(config.facility);
            handler.setSyslogType(config.syslogType);
            handler.setProtocol(config.protocol);
            handler.setBlockOnReconnect(config.blockOnReconnect);
            handler.setTruncate(config.truncate);
            handler.setUseCountingFraming(config.useCountingFraming);
            handler.setLevel(config.level);
            PatternFormatter formatter = new PatternFormatter(config.format);
            handler.setFormatter(formatter);
            handler.setErrorManager(errorManager);
            handler.setFilter(logCleanupFilter);
            if (config.async.enable) {
                return LoggingSetupRecorder.createAsyncHandler(config.async, config.level, handler);
            }
            return handler;
        }
        catch (IOException e) {
            errorManager.error("Failed to create syslog handler", e, 4);
            return null;
        }
    }

    private static AsyncHandler createAsyncHandler(AsyncConfig asyncConfig, Level level, Handler handler) {
        AsyncHandler asyncHandler = new AsyncHandler(asyncConfig.queueLength);
        asyncHandler.setOverflowAction(asyncConfig.overflow);
        asyncHandler.addHandler(handler);
        asyncHandler.setLevel(level);
        return asyncHandler;
    }

    private static class AdditionalNamedHandlersConsumer
    implements BiConsumer<String, Handler> {
        private final Map<String, Handler> additionalNamedHandlersMap;
        private final ErrorManager errorManager;
        private final List<LogCleanupFilterElement> filterElements;

        public AdditionalNamedHandlersConsumer(Map<String, Handler> additionalNamedHandlersMap, ErrorManager errorManager, List<LogCleanupFilterElement> filterElements) {
            this.additionalNamedHandlersMap = additionalNamedHandlersMap;
            this.errorManager = errorManager;
            this.filterElements = filterElements;
        }

        @Override
        public void accept(String name, Handler handler) {
            Handler previous = this.additionalNamedHandlersMap.putIfAbsent(name, handler);
            if (previous != null) {
                throw new IllegalStateException(String.format("Duplicate key %s (attempted merging values %s and %s)", name, previous, handler));
            }
            handler.setErrorManager(this.errorManager);
            handler.setFilter(new LogCleanupFilter(this.filterElements));
        }
    }

    private static class CategoryLoggerConsumer
    implements BiConsumer<String, CategoryConfig> {
        private final LogContext logContext;
        private final Map<String, Handler> namedHandlers;
        private final ErrorManager errorManager;

        CategoryLoggerConsumer(LogContext logContext, Map<String, Handler> namedHandlers, ErrorManager errorManager) {
            this.logContext = logContext;
            this.namedHandlers = namedHandlers;
            this.errorManager = errorManager;
        }

        @Override
        public void accept(String name, CategoryConfig categoryConfig) {
            Logger categoryLogger = this.logContext.getLogger(name);
            if (!categoryConfig.level.isInherited()) {
                categoryLogger.setLevel(categoryConfig.level.getLevel());
            }
            categoryLogger.setUseParentHandlers(categoryConfig.useParentHandlers);
            if (categoryConfig.handlers.isPresent()) {
                LoggingSetupRecorder.addNamedHandlersToCategory(categoryConfig, this.namedHandlers, categoryLogger, this.errorManager);
            }
        }
    }
}

