/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import org.infinispan.config.AbstractConfigurationBeanVisitor;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.loaders.decorators.AsyncStoreConfig;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TimeoutConfigurationValidatingVisitor
extends AbstractConfigurationBeanVisitor {
    private static final Log log = LogFactory.getLog(TimeoutConfigurationValidatingVisitor.class);
    private AsyncStoreConfig asyncType = null;
    private GlobalConfiguration global = null;

    @Override
    public void visitAsyncStoreConfig(AsyncStoreConfig bean) {
        this.asyncType = bean;
    }

    @Override
    public void visitGlobalConfiguration(GlobalConfiguration bean) {
        this.global = bean;
    }

    @Override
    public void visitConfiguration(Configuration bean) {
        boolean nonLocalCache;
        boolean bl = nonLocalCache = bean.getCacheMode() != Configuration.CacheMode.LOCAL && this.global.getTransportClass() != null;
        if (nonLocalCache) {
            if (this.asyncType != null && this.asyncType.getFlushLockTimeout() > this.asyncType.getShutdownTimeout()) {
                log.invalidTimeoutValue((Object)"<async>: flushLockTimeout ", (Object)this.asyncType.getFlushLockTimeout(), (Object)"<async>: shutdownTimeout ", (Object)this.asyncType.getShutdownTimeout());
            }
            if (this.asyncType != null && this.asyncType.getShutdownTimeout() > (long)bean.getCacheStopTimeout()) {
                log.invalidTimeoutValue((Object)"<async>: shutdownTimeout ", (Object)this.asyncType.getShutdownTimeout(), (Object)"<transaction>: cacheStopTimeout ", (Object)bean.getCacheStopTimeout());
            }
            if (bean.getDeadlockDetectionSpinDuration() > bean.getLockAcquisitionTimeout()) {
                log.invalidTimeoutValue((Object)"<deadlockDetection>: spinDuration", (Object)bean.getDeadlockDetectionSpinDuration(), (Object)"<locking>:lockAcquisitionTimeout ", (Object)bean.getLockAcquisitionTimeout());
            }
            if (this.asyncType != null && bean.getLockAcquisitionTimeout() > bean.getSyncReplTimeout()) {
                log.invalidTimeoutValue((Object)"<locking>:lockAcquisitionTimeout ", (Object)bean.getLockAcquisitionTimeout(), (Object)"<sync>:replTimeout", (Object)bean.getSyncReplTimeout());
            }
            if (this.asyncType != null && bean.getSyncReplTimeout() > this.global.getDistributedSyncTimeout()) {
                log.invalidTimeoutValue((Object)"<sync>:replTimeout", (Object)bean.getSyncReplTimeout(), (Object)"<transport>: distributedSyncTimeout", (Object)this.global.getDistributedSyncTimeout());
            }
            if (this.global.getDistributedSyncTimeout() > bean.getStateRetrievalTimeout()) {
                log.invalidTimeoutValue((Object)"<transport>: distributedSyncTimeout", (Object)this.global.getDistributedSyncTimeout(), (Object)"<stateRetrieval>:timeout", (Object)bean.getStateRetrievalTimeout());
            }
        }
    }
}

