/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.decorators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import net.jcip.annotations.GuardedBy;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.decorators.AbstractDelegatingStore;
import org.infinispan.loaders.decorators.AsyncStoreConfig;
import org.infinispan.loaders.modifications.Clear;
import org.infinispan.loaders.modifications.Modification;
import org.infinispan.loaders.modifications.ModificationsList;
import org.infinispan.loaders.modifications.Remove;
import org.infinispan.loaders.modifications.Store;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class AsyncStore
extends AbstractDelegatingStore {
    private static final Log log = LogFactory.getLog(AsyncStore.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final AtomicInteger threadId = new AtomicInteger(0);
    private final AsyncStoreConfig asyncStoreConfig;
    private final TransactionFactory txFactory;
    private Map<GlobalTransaction, List<? extends Modification>> transactions;
    private ExecutorService executor;
    private Thread coordinator;
    private int concurrencyLevel;
    private long shutdownTimeout;
    private String cacheName;
    private BufferLock stateLock;
    @GuardedBy(value="stateLock")
    private volatile State state;

    public AsyncStore(CacheStore delegate, AsyncStoreConfig asyncStoreConfig) {
        super(delegate);
        this.asyncStoreConfig = asyncStoreConfig;
        this.txFactory = new TransactionFactory();
        this.txFactory.init(false, false, false, false);
    }

    @Override
    public void init(CacheLoaderConfig config, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        super.init(config, cache, m);
        Configuration cacheCfg = cache != null ? cache.getCacheConfiguration() : null;
        this.concurrencyLevel = cacheCfg != null ? cacheCfg.locking().concurrencyLevel() : 16;
        long cacheStopTimeout = cacheCfg != null ? cacheCfg.transaction().cacheStopTimeout() : 30000L;
        Long configuredAsyncStopTimeout = this.asyncStoreConfig.getShutdownTimeout();
        String string = this.cacheName = cache != null ? cache.getName() : null;
        if (configuredAsyncStopTimeout >= cacheStopTimeout) {
            this.shutdownTimeout = Math.round((double)cacheStopTimeout * 0.9);
            log.asyncStoreShutdownTimeoutTooHigh(configuredAsyncStopTimeout.longValue(), cacheStopTimeout, this.shutdownTimeout);
        } else {
            this.shutdownTimeout = configuredAsyncStopTimeout;
        }
        this.transactions = new ConcurrentHashMap<GlobalTransaction, List<? extends Modification>>(64);
    }

    private State newState(boolean clear, State next) {
        ConcurrentHashMap map = new ConcurrentHashMap(64);
        return new State(clear, map, next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(Modification mod, int count) {
        this.stateLock.writeLock(count);
        try {
            if (log.isTraceEnabled()) {
                log.tracef("Queue modification: %s", (Object)mod);
            }
            this.state.put(mod);
        }
        finally {
            this.stateLock.writeUnlock();
        }
    }

    @Override
    public InternalCacheEntry load(Object key) throws CacheLoaderException {
        Modification mod = this.state.get(key);
        if (mod != null) {
            switch (mod.getType()) {
                case REMOVE: 
                case CLEAR: {
                    return null;
                }
                case STORE: {
                    InternalCacheEntry ice = ((Store)mod).getStoredEntry();
                    if (ice.isExpired()) {
                        return null;
                    }
                    return ice;
                }
            }
        }
        return super.load(key);
    }

    @Override
    public boolean containsKey(Object key) throws CacheLoaderException {
        Modification mod = this.state.get(key);
        if (mod != null) {
            return mod.getType() == Modification.Type.STORE;
        }
        return super.containsKey(key);
    }

    private void loadKeys(State s, Set<Object> exclude, Set<Object> result) throws CacheLoaderException {
        if (!s.clear) {
            State next = s.next;
            if (next != null) {
                this.loadKeys(next, exclude, result);
            } else {
                result.addAll(super.loadAllKeys(exclude));
            }
        }
        for (Modification mod : s.modifications.values()) {
            switch (mod.getType()) {
                case STORE: {
                    Object key = ((Store)mod).getStoredEntry().getKey();
                    if (exclude != null && exclude.contains(key)) break;
                    result.add(key);
                    break;
                }
                case REMOVE: {
                    result.remove(((Remove)mod).getKey());
                }
            }
        }
    }

    @Override
    public Set<Object> loadAllKeys(Set<Object> keysToExclude) throws CacheLoaderException {
        HashSet<Object> result = new HashSet<Object>();
        this.loadKeys(this.state, keysToExclude, result);
        return result;
    }

    @Override
    public Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        return this.load(Integer.MAX_VALUE);
    }

    @Override
    public Set<InternalCacheEntry> load(int numEntries) throws CacheLoaderException {
        HashSet<InternalCacheEntry> result = new HashSet<InternalCacheEntry>();
        for (Object key : this.loadAllKeys(null)) {
            InternalCacheEntry entry = this.load(key);
            if (entry == null) continue;
            result.add(entry);
            if (result.size() != numEntries) continue;
            return result;
        }
        return result;
    }

    @Override
    public void store(InternalCacheEntry entry) {
        this.put(new Store(entry), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.stateLock.writeLock(1);
        try {
            this.state = this.newState(true, this.state.next);
        }
        finally {
            this.stateLock.reset(1);
            this.stateLock.writeUnlock();
        }
    }

    @Override
    public boolean remove(Object key) {
        this.put(new Remove(key), 1);
        return true;
    }

    @Override
    public void removeAll(Set<Object> keys) throws CacheLoaderException {
        if (keys != null && !keys.isEmpty()) {
            ArrayList<Remove> mods = new ArrayList<Remove>(keys.size());
            for (Object key : keys) {
                mods.add(new Remove(key));
            }
            this.put(new ModificationsList(mods), mods.size());
        }
    }

    @Override
    public void prepare(List<? extends Modification> mods, GlobalTransaction tx, boolean isOnePhase) throws CacheLoaderException {
        if (isOnePhase) {
            this.enqueueModificationsList(mods);
        } else {
            this.transactions.put(tx, mods);
        }
    }

    @Override
    public void rollback(GlobalTransaction tx) {
        this.transactions.remove(tx);
    }

    @Override
    public void commit(GlobalTransaction tx) throws CacheLoaderException {
        this.enqueueModificationsList(this.transactions.remove(tx));
    }

    private void enqueueModificationsList(List<? extends Modification> mods) {
        int i;
        if (mods == null || mods.isEmpty()) {
            return;
        }
        for (i = mods.size() - 1; i >= 0 && mods.get(i).getType() != Modification.Type.CLEAR; --i) {
        }
        if (i >= 0) {
            this.clear();
            mods = mods.subList(i + 1, mods.size());
        }
        if (!mods.isEmpty()) {
            this.put(new ModificationsList(mods), mods.size());
        }
    }

    @Override
    public void start() throws CacheLoaderException {
        log.debugf("Async cache loader starting %s", (Object)this);
        this.state = this.newState(false, null);
        this.stateLock = new BufferLock(this.asyncStoreConfig.getModificationQueueSize());
        super.start();
        int poolSize = this.asyncStoreConfig.getThreadPoolSize();
        this.executor = new ThreadPoolExecutor(0, poolSize, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "AsyncStoreProcessor-" + AsyncStore.this.cacheName + "-" + threadId.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        });
        this.coordinator = new Thread((Runnable)new AsyncStoreCoordinator(), "AsyncStoreCoordinator-" + this.cacheName);
        this.coordinator.setDaemon(true);
        this.coordinator.start();
    }

    @Override
    public void stop() throws CacheLoaderException {
        log.trace((Object)"Stop async store");
        this.stateLock.writeLock(1);
        this.state.stopped = true;
        this.stateLock.writeUnlock();
        try {
            this.coordinator.join(this.shutdownTimeout);
            if (this.coordinator.isAlive()) {
                log.error((Object)"Async store executor did not stop properly");
            }
        }
        catch (InterruptedException e) {
            log.interruptedWaitingAsyncStorePush(e);
            Thread.currentThread().interrupt();
        }
        super.stop();
    }

    protected void applyModificationsSync(List<Modification> mods) throws CacheLoaderException {
        this.getDelegate().prepare(mods, this.txFactory.newGlobalTransaction(null, false), true);
    }

    static /* synthetic */ boolean access$1000() {
        return trace;
    }

    static /* synthetic */ ExecutorService access$1200(AsyncStore x0) {
        return x0.executor;
    }

    static /* synthetic */ long access$1300(AsyncStore x0) {
        return x0.shutdownTimeout;
    }

    static /* synthetic */ BufferLock access$1400(AsyncStore x0) {
        return x0.stateLock;
    }

    static /* synthetic */ State access$1102(AsyncStore x0, State x1) {
        x0.state = x1;
        return x0.state;
    }

    static /* synthetic */ State access$1500(AsyncStore x0, boolean x1, State x2) {
        return x0.newState(x1, x2);
    }

    static /* synthetic */ AsyncStoreConfig access$1700(AsyncStore x0) {
        return x0.asyncStoreConfig;
    }

    private class AsyncStoreProcessor
    implements Runnable {
        private final List<Modification> modifications;
        private final State myState;

        AsyncStoreProcessor(List<Modification> modifications, State myState) {
            this.modifications = modifications;
            this.myState = myState;
        }

        @Override
        public void run() {
            this.retryWork(3);
            this.myState.workerThreads.countDown();
            if (this.myState.workerThreads.getCount() == 0L) {
                State s = AsyncStore.this.state;
                while (s != null) {
                    if (s.next == this.myState) {
                        s.next = null;
                    }
                    s = s.next;
                }
            }
        }

        private void retryWork(int maxRetries) {
            for (int attempt = 0; attempt < maxRetries; ++attempt) {
                if (attempt > 0 && log.isDebugEnabled()) {
                    log.debugf("Retrying due to previous failure. %s attempts left.", (Object)(maxRetries - attempt));
                }
                try {
                    AsyncStore.this.applyModificationsSync(this.modifications);
                    return;
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Failed to process async modifications", (Throwable)e);
                    continue;
                }
            }
            log.unableToProcessAsyncModifications(maxRetries);
        }
    }

    private class AsyncStoreCoordinator
    implements Runnable {
        private AsyncStoreCoordinator() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 25[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean shouldStop(State s) {
            return s.stopped && s.modifications.isEmpty();
        }
    }

    private static class BufferLock {
        private final Sync sync = new Sync();
        private final Counter counter;
        private final Available available;

        BufferLock(int size) {
            this.counter = size > 0 ? new Counter(size) : null;
            this.available = new Available();
        }

        void writeLock(int count) {
            if (this.counter != null) {
                this.counter.acquireShared(count);
            }
            this.sync.acquireShared(1);
        }

        void writeUnlock() {
            this.sync.releaseShared(1);
            this.available.releaseShared(1);
        }

        void readLock() {
            this.available.acquireShared(1);
            this.sync.acquire(1);
        }

        void readUnlock() {
            this.sync.release(1);
        }

        void reset(int count) {
            if (this.counter != null) {
                this.counter.releaseShared(count);
            }
            this.available.releaseShared(count);
        }

        void add(int count) {
            if (this.counter != null) {
                count = this.counter.add(count);
            }
            this.available.releaseShared(count);
        }

        private static class Sync
        extends AbstractQueuedSynchronizer {
            private static final long serialVersionUID = 2983687000985096017L;

            private Sync() {
            }

            @Override
            protected boolean tryAcquire(int unused) {
                if (!this.compareAndSetState(0, -1)) {
                    return false;
                }
                this.setExclusiveOwnerThread(Thread.currentThread());
                return true;
            }

            @Override
            protected boolean tryRelease(int unused) {
                this.setExclusiveOwnerThread(null);
                this.setState(0);
                return true;
            }

            @Override
            protected int tryAcquireShared(int unused) {
                int state;
                do {
                    if ((state = this.getState()) >= 0) continue;
                    return -1;
                } while (!this.compareAndSetState(state, state + 1));
                return 1;
            }

            @Override
            protected boolean tryReleaseShared(int unused) {
                int state;
                while (!this.compareAndSetState(state = this.getState(), state - 1)) {
                }
                return true;
            }
        }

        private static class Available
        extends AbstractQueuedSynchronizer {
            private static final long serialVersionUID = 6464514100313353749L;

            private Available() {
            }

            @Override
            protected int tryAcquireShared(int unused) {
                return this.getState() > 0 ? 1 : -1;
            }

            @Override
            protected boolean tryReleaseShared(int state) {
                this.setState(state > 0 ? 1 : 0);
                return state > 0;
            }
        }

        private static class Counter
        extends AbstractQueuedSynchronizer {
            private static final long serialVersionUID = 1688655561670368887L;
            private final int size;

            Counter(int size) {
                this.size = size;
            }

            int add(int count) {
                int state;
                while (!this.compareAndSetState(state = this.getState(), state + count)) {
                }
                return state + count;
            }

            @Override
            protected int tryAcquireShared(int count) {
                int state;
                do {
                    if ((state = this.getState()) < this.size) continue;
                    return -1;
                } while (!this.compareAndSetState(state, state + count));
                return state + count >= this.size ? 0 : 1;
            }

            @Override
            protected boolean tryReleaseShared(int state) {
                this.setState(state);
                return state < this.size;
            }
        }
    }

    private static class State {
        private static final Clear CLEAR = new Clear();
        private final boolean clear;
        private final ConcurrentMap<Object, Modification> modifications;
        private volatile State next;
        private volatile boolean stopped = false;
        private CountDownLatch workerThreads;

        private State(boolean clear, ConcurrentMap<Object, Modification> modMap, State next) {
            this.clear = clear;
            this.modifications = modMap;
            this.next = next;
            if (next != null) {
                this.stopped = next.stopped;
            }
        }

        Modification get(Object key) {
            State state = this;
            while (state != null) {
                Modification mod = (Modification)state.modifications.get(key);
                if (mod != null) {
                    return mod;
                }
                if (state.clear) {
                    return CLEAR;
                }
                state = state.next;
            }
            return null;
        }

        void put(Modification mod) {
            if (this.stopped) {
                throw new CacheException("AsyncStore stopped; no longer accepting more entries.");
            }
            switch (mod.getType()) {
                case STORE: {
                    this.modifications.put(((Store)mod).getStoredEntry().getKey(), mod);
                    break;
                }
                case REMOVE: {
                    this.modifications.put(((Remove)mod).getKey(), mod);
                    break;
                }
                case LIST: {
                    for (Modification modification : ((ModificationsList)mod).getList()) {
                        this.put(modification);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown modification type " + (Object)((Object)mod.getType()));
                }
            }
        }

        static /* synthetic */ CountDownLatch access$1602(State x0, CountDownLatch x1) {
            x0.workerThreads = x1;
            return x0.workerThreads;
        }
    }
}

