/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.compatibility.adaptor52x;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.compatibility.adaptor52x.Adaptor52xStore;
import org.infinispan.compatibility.loaders.Custom52xCacheStore;
import org.infinispan.compatibility.loaders.Custom52xCacheStoreConfig;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.BaseStoreTest;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="compatibility.adaptor52x.Adaptor52xCustomLoaderTest")
public class Adaptor52xCustomLoaderTest
extends BaseStoreTest {
    public static final String DIR = "__tmp_to_del___";
    private Cache<Object, Object> cache;
    private DefaultCacheManager dcm;
    protected String configurationFile = "52x-custom-loader.xml";

    protected AdvancedLoadWriteStore createStore() throws Exception {
        TestingUtil.recursiveFileRemove((String)DIR);
        this.dcm = new DefaultCacheManager(this.configurationFile);
        return this.getAdvancedLoadWriteStore();
    }

    private AdvancedLoadWriteStore getAdvancedLoadWriteStore() {
        this.cache = this.dcm.getCache("customLoaderCache");
        return (AdvancedLoadWriteStore)TestingUtil.getFirstLoader(this.cache);
    }

    @AfterMethod
    public void tearDown() throws PersistenceException {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.dcm});
        TestingUtil.recursiveFileRemove((String)DIR);
    }

    public void testPreloadAndExpiry() {
        assert (this.cache.getCacheConfiguration().persistence().preload().booleanValue());
        this.cache.put((Object)"k1", (Object)"v");
        this.cache.put((Object)"k2", (Object)"v", 111111L, TimeUnit.MILLISECONDS);
        this.cache.put((Object)"k3", (Object)"v", -1L, TimeUnit.MILLISECONDS, 222222L, TimeUnit.MILLISECONDS);
        this.cache.put((Object)"k4", (Object)"v", 333333L, TimeUnit.MILLISECONDS, 444444L, TimeUnit.MILLISECONDS);
        this.assertCacheEntry(this.cache, "k1", "v", -1L, -1L);
        this.assertCacheEntry(this.cache, "k2", "v", 111111L, -1L);
        this.assertCacheEntry(this.cache, "k3", "v", -1L, 222222L);
        this.assertCacheEntry(this.cache, "k4", "v", 333333L, 444444L);
        this.cache.stop();
        this.cache.start();
        this.cl = this.getAdvancedLoadWriteStore();
        this.assertCacheEntry(this.cache, "k1", "v", -1L, -1L);
        this.assertCacheEntry(this.cache, "k2", "v", 111111L, -1L);
        this.assertCacheEntry(this.cache, "k3", "v", -1L, 222222L);
        this.assertCacheEntry(this.cache, "k4", "v", 333333L, 444444L);
    }

    private void assertCacheEntry(Cache cache, String key, String value, long lifespanMillis, long maxIdleMillis) {
        DataContainer dc = cache.getAdvancedCache().getDataContainer();
        InternalCacheEntry ice = dc.get((Object)key);
        assert (ice != null) : "No such entry for key " + key;
        assert (Util.safeEquals((Object)ice.getValue(), (Object)value)) : ice.getValue() + " is not the same as " + value;
        assert (ice.getLifespan() == lifespanMillis) : "Lifespan " + ice.getLifespan() + " not the same as " + lifespanMillis;
        assert (ice.getMaxIdle() == maxIdleMillis) : "MaxIdle " + ice.getMaxIdle() + " not the same as " + maxIdleMillis;
        if (lifespanMillis > -1L) assert (ice.getCreated() > -1L) : "Lifespan is set but created time is not";
        if (maxIdleMillis > -1L) assert (ice.getLastUsed() > -1L) : "Max idle is set but last used is not";
    }

    public void testLocationIsCorrect() {
        Custom52xCacheStoreConfig config = ((Custom52xCacheStore)((Adaptor52xStore)this.cl).getLoader()).getConfig();
        Assert.assertEquals((String)config.getLocation(), (String)DIR);
    }

    protected StreamingMarshaller getMarshaller() {
        return this.cache.getAdvancedCache().getComponentRegistry().getCacheMarshaller();
    }
}

