/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.avro.server;

import example.avro.DeviceList;
import example.avro.Employee;
import example.avro.User;
import example.avro.WebPage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.specific.SpecificRecord;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.infinispan.Cache;
import org.infinispan.avro.client.AbstractMarshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="org.infinispan.avro.server.AvroWrapperIndexingTest")
public class AvroWrapperIndexingTest
extends SingleCacheManagerTest {
    private static SimpleExternalizer externalizer = new SimpleExternalizer();

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(false);
        cfg.indexing().enable().addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        cfg.validate();
        Configuration configuration = cfg.build();
        assert (cfg.clustering().cacheMode() == CacheMode.LOCAL);
        DefaultCacheManager cacheManager = new DefaultCacheManager(configuration);
        cacheManager.getCache();
        return cacheManager;
    }

    @Test
    public void testIndexingWithWrapper() throws Exception {
        User user = User.newBuilder().build();
        user.setName("Alice");
        user.setFavoriteNumber(12);
        this.addToCache(user);
        final HashMap<String, String> hardDrives = new HashMap<String, String>(){
            {
                this.put("STCD00502", "SEAGATE");
                this.put("STA045M", "SEAGATE");
            }
        };
        DeviceList deviceList = DeviceList.newBuilder().build();
        deviceList.setDevices((List<Map<String, String>>)new ArrayList<Map<String, String>>(){
            {
                this.add(hardDrives);
            }
        });
        deviceList.setName("my devices");
        this.addToCache(deviceList);
        WebPage page = WebPage.newBuilder().build();
        page.setKey("http://www.test.com");
        HashMap<String, String> outlinks = new HashMap<String, String>();
        outlinks.put("1", "http://www.example.com");
        page.setOutlinks(outlinks);
        this.addToCache(page);
        SearchManager sm = Search.getSearchManager((Cache)this.cache);
        Query luceneQuery = ((TermMatchingContext)((TermMatchingContext)sm.buildQueryBuilderForClass(GenericData.Record.class).get().keyword().onField("name").ignoreFieldBridge()).ignoreAnalyzer()).matching((Object)"Alice").createQuery();
        List list = sm.getQuery(luceneQuery, new Class[0]).list();
        Assert.assertEquals((int)1, (int)list.size());
        Assert.assertEquals(list.get(0), (Object)this.toGeneric(user));
        luceneQuery = NumericRangeQuery.newIntRange((String)"favorite_number", (int)8, (Integer)0, (Integer)12, (boolean)true, (boolean)true);
        list = sm.getQuery(luceneQuery, new Class[0]).list();
        Assert.assertEquals((int)1, (int)list.size());
        Assert.assertEquals(list.get(0), (Object)this.toGeneric(user));
        luceneQuery = ((TermMatchingContext)((TermMatchingContext)sm.buildQueryBuilderForClass(GenericData.Record.class).get().keyword().onField("name").ignoreFieldBridge()).ignoreAnalyzer()).matching((Object)"Bob").createQuery();
        list = sm.getQuery(luceneQuery, new Class[0]).list();
        Assert.assertEquals((int)0, (int)list.size());
        luceneQuery = ((TermMatchingContext)((TermMatchingContext)sm.buildQueryBuilderForClass(GenericData.Record.class).get().keyword().onField("devices.0").ignoreFieldBridge()).ignoreAnalyzer()).matching((Object)"STCD00502.SEAGATE").createQuery();
        list = sm.getQuery(luceneQuery, new Class[0]).list();
        Assert.assertEquals((int)1, (int)list.size());
        Assert.assertEquals(list.get(0), (Object)this.toGeneric(deviceList));
        luceneQuery = ((TermMatchingContext)((TermMatchingContext)sm.buildQueryBuilderForClass(GenericData.Record.class).get().keyword().onField("outlinks").ignoreFieldBridge()).ignoreAnalyzer()).matching((Object)"1.http://www.example.com").createQuery();
        list = sm.getQuery(luceneQuery, new Class[0]).list();
        Assert.assertEquals((int)1, (int)list.size());
        Assert.assertEquals(list.get(0), (Object)this.toGeneric(page));
    }

    private void addToCache(SpecificRecord record) {
        this.cache.put(record.get(0), (Object)this.toGeneric(record));
    }

    private GenericData.Record toGeneric(SpecificRecord record) {
        try {
            return (GenericData.Record)externalizer.objectFromByteBuffer(externalizer.objectToByteBuffer(record));
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class SimpleExternalizer
    extends AbstractMarshaller {
        private Map<String, Schema> knownSchema;
        private final SpecificRecord[] classList = new SpecificRecord[]{new User(), new DeviceList(), new Employee(), new WebPage()};

        public SimpleExternalizer() {
            this.knownSchema = new HashMap<String, Schema>();
            for (SpecificRecord record : this.classList) {
                this.knownSchema.put(record.getSchema().getFullName(), record.getSchema());
            }
        }

        protected DatumReader reader(String schemaName) throws InterruptedException, IOException, ClassNotFoundException {
            return new GenericDatumReader(this.knownSchema.get(schemaName));
        }
    }
}

