/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.avro.server;

import java.util.Map;
import org.infinispan.avro.server.Externalizer;
import org.infinispan.avro.server.ExternalizerIds;
import org.infinispan.avro.server.MetadataManager;
import org.infinispan.avro.server.RemoteValueWrapperInterceptor;
import org.infinispan.commons.logging.Log;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.CustomInterceptorsConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.InterceptorConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.InvocationContextInterceptor;
import org.infinispan.lifecycle.AbstractModuleLifecycle;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.logging.LogFactory;

public class LifecycleManager
extends AbstractModuleLifecycle {
    private static final Log log = (Log)LogFactory.getLog(LifecycleManager.class, Log.class);

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalCfg) {
        Map externalizerMap = globalCfg.serialization().advancedExternalizers();
        externalizerMap.put(ExternalizerIds.AVRO_VALUE_WRAPPER, Externalizer.getInstance());
    }

    public void cacheManagerStarted(GlobalComponentRegistry gcr) {
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)gcr.getComponent(EmbeddedCacheManager.class);
        MetadataManager.setInstance(new MetadataManager((DefaultCacheManager)cacheManager));
    }

    public void cacheManagerStopping(GlobalComponentRegistry gcr) {
    }

    public void cacheStarting(ComponentRegistry cr, Configuration cfg, String cacheName) {
        if (!cacheName.equals("__avro_metadata") && cfg.indexing().index().isEnabled() && !cfg.compatibility().enabled()) {
            log.infof("Registering RemoteAvroValueWrapperInterceptor for cache %s", (Object)cacheName);
            this.createRemoteIndexingInterceptor(cr, cfg);
        }
    }

    private void createRemoteIndexingInterceptor(ComponentRegistry cr, Configuration cfg) {
        RemoteValueWrapperInterceptor wrapperInterceptor = (RemoteValueWrapperInterceptor)((Object)cr.getComponent(RemoteValueWrapperInterceptor.class));
        if (wrapperInterceptor == null) {
            wrapperInterceptor = new RemoteValueWrapperInterceptor();
            InterceptorChain ic = (InterceptorChain)cr.getComponent(InterceptorChain.class);
            ConfigurationBuilder builder = new ConfigurationBuilder().read(cfg);
            InterceptorConfigurationBuilder interceptorBuilder = builder.customInterceptors().addInterceptor();
            interceptorBuilder.interceptor(wrapperInterceptor);
            if (ic != null) {
                ic.addInterceptorAfter(wrapperInterceptor, InvocationContextInterceptor.class);
            }
            interceptorBuilder.after(InvocationContextInterceptor.class);
            if (ic != null) {
                cr.registerComponent(wrapperInterceptor, RemoteValueWrapperInterceptor.class);
            }
            cfg.customInterceptors().interceptors(builder.build().customInterceptors().interceptors());
        }
    }

    public void cacheStarted(ComponentRegistry cr, String cacheName) {
        boolean remoteValueWrappingEnabled;
        Configuration configuration = (Configuration)cr.getComponent(Configuration.class);
        boolean bl = remoteValueWrappingEnabled = configuration.indexing().index().isEnabled() && !configuration.compatibility().enabled();
        if (!remoteValueWrappingEnabled) {
            if (this.verifyChainContainsRemoteAvroValueWrapperInterceptor(cr)) {
                throw new IllegalStateException("It was NOT expected to find the RemoteAvroValueWrapperInterceptor registered in the InterceptorChain as indexing was disabled, but it was found");
            }
            return;
        }
        if (!this.verifyChainContainsRemoteAvroValueWrapperInterceptor(cr)) {
            throw new IllegalStateException("It was expected to find the RemoteAvroValueWrapperInterceptor registered in the InterceptorChain but it wasn't found");
        }
    }

    private boolean verifyChainContainsRemoteAvroValueWrapperInterceptor(ComponentRegistry cr) {
        InterceptorChain interceptorChain = (InterceptorChain)cr.getComponent(InterceptorChain.class);
        return interceptorChain.containsInterceptorType(RemoteValueWrapperInterceptor.class, true);
    }

    public void cacheStopped(ComponentRegistry cr, String cacheName) {
        Configuration cfg = (Configuration)cr.getComponent(Configuration.class);
        this.removeRemoteIndexingInterceptorFromConfig(cfg);
    }

    private void removeRemoteIndexingInterceptorFromConfig(Configuration cfg) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        CustomInterceptorsConfigurationBuilder customInterceptorsBuilder = builder.customInterceptors();
        for (InterceptorConfiguration interceptorConfig : cfg.customInterceptors().interceptors()) {
            if (interceptorConfig.interceptor() instanceof RemoteValueWrapperInterceptor) continue;
            customInterceptorsBuilder.addInterceptor().read(interceptorConfig);
        }
        cfg.customInterceptors().interceptors(builder.build().customInterceptors().interceptors());
    }
}

