/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.avro.server;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.avro.Schema;
import org.infinispan.avro.client.Request;
import org.infinispan.avro.client.Response;
import org.infinispan.avro.server.Externalizer;
import org.infinispan.avro.server.QueryFacade;
import org.infinispan.commons.equivalence.ByteArrayEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.LogFactory;

public class MetadataManager {
    private static MetadataManager instance;
    private static final Log log;
    private DefaultCacheManager cacheManager;
    private ConcurrentMap<String, Schema> knownSchemas;
    private Marshaller marshaller;

    public static MetadataManager getInstance() {
        return instance;
    }

    public static void setInstance(MetadataManager instance) {
        MetadataManager.instance = instance;
    }

    public MetadataManager(DefaultCacheManager cacheManager) {
        Configuration cacheConfiguration = cacheManager.getCacheConfiguration("__avro_metadata");
        if (cacheConfiguration == null) {
            ConfigurationBuilder cfg = new ConfigurationBuilder();
            CacheMode cacheMode = cacheManager.getDefaultCacheConfiguration().clustering().cacheMode().equals((Object)CacheMode.LOCAL) ? CacheMode.LOCAL : CacheMode.REPL_SYNC;
            cfg.transaction().lockingMode(LockingMode.PESSIMISTIC).syncCommitPhase(true).syncRollbackPhase(true).persistence().addSingleFileStore().location(System.getProperty("java.io.tmpdir") + "/" + cacheManager.getNodeAddress()).locking().isolationLevel(IsolationLevel.READ_COMMITTED).useLockStriping(false).clustering().cacheMode(cacheMode).stateTransfer().fetchInMemoryState(true).dataContainer().keyEquivalence((Equivalence)new ByteArrayEquivalence());
            if (cacheMode.equals((Object)CacheMode.REPL_SYNC)) {
                cfg.clustering().stateTransfer().awaitInitialTransfer(true);
            }
            cacheManager.defineConfiguration("__avro_metadata", cfg.build());
            this.cacheManager = cacheManager;
            this.marshaller = Externalizer.getInstance();
            this.knownSchemas = new ConcurrentHashMap<String, Schema>();
            this.knownSchemas.put(Request.getClassSchema().getFullName(), Request.getClassSchema());
            this.knownSchemas.put(Response.getClassSchema().getFullName(), Response.getClassSchema());
        }
    }

    public Schema retrieveSchema(String name) throws IOException, InterruptedException, ClassNotFoundException {
        if (!this.knownSchemas.containsKey(name)) {
            byte[] key = this.marshaller.objectToByteBuffer((Object)name);
            byte[] value = (byte[])this.cacheManager.getCache("__avro_metadata").get((Object)key);
            if (value == null) {
                throw new IOException(name + " not found in the metadata cache");
            }
            Schema schema = (Schema)this.marshaller.objectFromByteBuffer(value);
            this.knownSchemas.put(name, schema);
            log.info((Object)("adding schama " + name + " to metadata cache"));
        }
        return (Schema)this.knownSchemas.get(name);
    }

    static {
        log = (Log)LogFactory.getLog(QueryFacade.class, Log.class);
    }
}

