/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.avro.server;

import java.io.IOException;
import java.util.Set;
import org.apache.avro.generic.GenericData;
import org.infinispan.avro.server.Externalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.compat.TypeConverter;
import org.infinispan.context.Flag;
import org.infinispan.interceptors.compat.BaseTypeConverterInterceptor;

public class RemoteValueWrapperInterceptor<K, V>
extends BaseTypeConverterInterceptor {
    private static final ValueWrapperTypeConverter avroTypeConverter = new ValueWrapperTypeConverter();
    private static final PassThroughTypeConverter passThroughTypeConverter = new PassThroughTypeConverter();

    protected TypeConverter<Object, Object, Object, Object> determineTypeConverter(Set<Flag> flags) {
        return flags != null && flags.contains(Flag.OPERATION_HOTROD) ? avroTypeConverter : passThroughTypeConverter;
    }

    private static class ValueWrapperTypeConverter
    extends PassThroughTypeConverter {
        Externalizer externalizer = Externalizer.getInstance();

        private ValueWrapperTypeConverter() {
        }

        @Override
        public Object boxValue(Object value) {
            if (value instanceof byte[]) {
                try {
                    return this.externalizer.objectFromByteBuffer((byte[])value);
                }
                catch (IOException | ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            return value;
        }

        @Override
        public Object unboxValue(Object target) {
            if (target instanceof GenericData.Record) {
                try {
                    return this.externalizer.objectToByteBuffer(target);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return target;
        }
    }

    private static class PassThroughTypeConverter
    implements TypeConverter<Object, Object, Object, Object> {
        private PassThroughTypeConverter() {
        }

        public Object boxKey(Object key) {
            return key;
        }

        public Object boxValue(Object value) {
            return value;
        }

        public Object unboxKey(Object target) {
            return target;
        }

        public Object unboxValue(Object target) {
            return target;
        }

        public boolean supportsInvocation(Flag flag) {
            return false;
        }

        public void setMarshaller(Marshaller marshaller) {
        }
    }
}

